/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server.plugin.servlet;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletDefinitions;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletMetadata;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletUtils;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletWithClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAdditionalServlets
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ProxyAdditionalServlets.class);
    private final Map<String, ProxyAdditionalServletWithClassLoader> servlets;

    public ProxyAdditionalServlets(Map<String, ProxyAdditionalServletWithClassLoader> servlets) {
        this.servlets = servlets;
    }

    public static ProxyAdditionalServlets load(ProxyConfiguration conf) throws IOException {
        ProxyAdditionalServletDefinitions definitions = ProxyAdditionalServletUtils.searchForServlets(conf.getProxyAdditionalServletDirectory(), null);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        conf.getProxyAdditionalServlets().forEach(servletName -> {
            ProxyAdditionalServletMetadata definition = definitions.servlets().get(servletName);
            if (null == definition) {
                throw new RuntimeException("No proxy additional servlet is found for name `" + servletName + "`. Available proxy additional servlet are : " + definitions.servlets());
            }
            try {
                ProxyAdditionalServletWithClassLoader servletWithClassLoader = ProxyAdditionalServletUtils.load(definition, conf.getNarExtractionDirectory());
                if (servletWithClassLoader != null) {
                    builder.put(servletName, (Object)servletWithClassLoader);
                }
                log.info("Successfully loaded proxy additional servlet for name `{}`", servletName);
            }
            catch (IOException e) {
                log.error("Failed to load the proxy additional servlet for name `" + servletName + "`", (Throwable)e);
                throw new RuntimeException("Failed to load the proxy additional servlet for name `" + servletName + "`");
            }
        });
        ImmutableMap servlets = builder.build();
        if (servlets != null && !servlets.isEmpty()) {
            return new ProxyAdditionalServlets((Map<String, ProxyAdditionalServletWithClassLoader>)servlets);
        }
        return null;
    }

    @Override
    public void close() {
        this.servlets.values().forEach(ProxyAdditionalServletWithClassLoader::close);
    }

    public Map<String, ProxyAdditionalServletWithClassLoader> getServlets() {
        return this.servlets;
    }
}

