/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.common.configuration.Category;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.configuration.PropertiesContext;
import org.apache.pulsar.common.configuration.PropertyContext;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.nar.NarClassLoader;

public class ProxyConfiguration
implements PulsarConfiguration {
    @Category
    private static final String CATEGORY_SERVER = "Server";
    @Category
    private static final String CATEGORY_BROKER_DISCOVERY = "Broker Discovery";
    @Category
    private static final String CATEGORY_AUTHENTICATION = "Proxy Authentication";
    @Category
    private static final String CATEGORY_AUTHORIZATION = "Proxy Authorization";
    @Category(description="the settings are for configuring how proxies authenticates with Pulsar brokers")
    private static final String CATEGORY_CLIENT_AUTHENTICATION = "Broker Client Authorization";
    @Category
    private static final String CATEGORY_RATE_LIMITING = "RateLimiting";
    @Category
    private static final String CATEGORY_TLS = "TLS";
    @Category
    private static final String CATEGORY_KEYSTORE_TLS = "KeyStoreTLS";
    @Category
    private static final String CATEGORY_TOKEN_AUTH = "Token Authentication Provider";
    @Category
    private static final String CATEGORY_HTTP = "HTTP";
    @Category
    private static final String CATEGORY_SASL_AUTH = "SASL Authentication Provider";
    @Category
    private static final String CATEGORY_PLUGIN = "proxy plugin";
    @Category
    private static final String CATEGORY_WEBSOCKET = "WebSocket";
    @FieldContext(category="Broker Discovery", doc="The ZooKeeper quorum connection string (as a comma-separated list)")
    private String zookeeperServers;
    @FieldContext(category="Broker Discovery", doc="Configuration store connection string (as a comma-separated list)")
    private String configurationStoreServers;
    @FieldContext(category="Broker Discovery", doc="Global ZooKeeper quorum connection string (as a comma-separated list)")
    @Deprecated
    private String globalZookeeperServers;
    @FieldContext(category="Broker Discovery", doc="ZooKeeper session timeout (in milliseconds)")
    private int zookeeperSessionTimeoutMs = 30000;
    @FieldContext(category="Broker Discovery", doc="ZooKeeper cache expiry time in seconds")
    private int zooKeeperCacheExpirySeconds = 300;
    @FieldContext(category="Broker Discovery", doc="The service url points to the broker cluster")
    private String brokerServiceURL;
    @FieldContext(category="Broker Discovery", doc="The tls service url points to the broker cluster")
    private String brokerServiceURLTLS;
    @FieldContext(category="Broker Discovery", doc="The web service url points to the broker cluster")
    private String brokerWebServiceURL;
    @FieldContext(category="Broker Discovery", doc="The tls web service url points to the broker cluster")
    private String brokerWebServiceURLTLS;
    @FieldContext(category="Broker Discovery", doc="The web service url points to the function worker cluster. Only configure it when you setup function workers in a separate cluster")
    private String functionWorkerWebServiceURL;
    @FieldContext(category="Broker Discovery", doc="The tls web service url points to the function worker cluster. Only configure it when you setup function workers in a separate cluster")
    private String functionWorkerWebServiceURLTLS;
    @FieldContext(category="Server", doc="Hostname or IP address the service binds on")
    private String bindAddress = "0.0.0.0";
    @FieldContext(category="Server", doc="Hostname or IP address the service advertises to the outside world. If not set, the value of `InetAddress.getLocalHost().getCanonicalHostName()` is used.")
    private String advertisedAddress;
    @FieldContext(category="Server", doc="Enable or disable the proxy protocol.")
    private boolean haProxyProtocolEnabled;
    @FieldContext(category="Server", doc="The port for serving binary protobuf request")
    private Optional<Integer> servicePort = Optional.ofNullable(6650);
    @FieldContext(category="Server", doc="The port for serving tls secured binary protobuf request")
    private Optional<Integer> servicePortTls = Optional.empty();
    @FieldContext(category="Server", doc="The port for serving http requests")
    private Optional<Integer> webServicePort = Optional.ofNullable(8080);
    @FieldContext(category="Server", doc="The port for serving https requests")
    private Optional<Integer> webServicePortTls = Optional.empty();
    @FieldContext(category="Server", doc="The directory where nar Extraction happens")
    private String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
    @FieldContext(category="Server", doc="Proxy log level, default is 0. 0: Do not log any tcp channel info 1: Parse and log any tcp channel info and command info without message body 2: Parse and log channel info, command info and message body")
    private Optional<Integer> proxyLogLevel = Optional.ofNullable(0);
    @FieldContext(category="Server", doc="Path for the file used to determine the rotation status for the proxy instance when responding to service discovery health checks")
    private String statusFilePath;
    @FieldContext(category="Proxy Authorization", doc="A list of role names (a comma-separated list of strings) that are treated as `super-user`, meaning they will be able to do all admin operations and publish & consume from all topics")
    private Set<String> superUserRoles = Sets.newTreeSet();
    @FieldContext(category="Proxy Authentication", doc="Whether authentication is enabled for the Pulsar proxy")
    private boolean authenticationEnabled = false;
    @FieldContext(category="Proxy Authentication", doc="Authentication provider name list (a comma-separated list of class names")
    private Set<String> authenticationProviders = Sets.newTreeSet();
    @FieldContext(category="Proxy Authorization", doc="Whether authorization is enforced by the Pulsar proxy")
    private boolean authorizationEnabled = false;
    @FieldContext(category="Proxy Authorization", doc="Authorization provider as a fully qualified class name")
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @FieldContext(category="Proxy Authorization", doc="Whether client authorization credentials are forwarded to the broker for re-authorization.Authentication must be enabled via configuring `authenticationEnabled` to be true for thisto take effect")
    private boolean forwardAuthorizationCredentials = false;
    @FieldContext(category="Proxy Authentication", doc="Whether the '/metrics' endpoint requires authentication. Defaults to true.'authenticationEnabled' must also be set for this to take effect.")
    private boolean authenticateMetricsEndpoint = true;
    @FieldContext(category="SASL Authentication Provider", doc="This is a regexp, which limits the range of possible ids which can connect to the Broker using SASL.\n Default value is: \".*pulsar.*\", so only clients whose id contains 'pulsar' are allowed to connect.")
    private String saslJaasClientAllowedIds = ".*pulsar.*";
    @FieldContext(category="SASL Authentication Provider", doc="Service Principal, for login context name. Default value is \"PulsarProxy\".")
    private String saslJaasServerSectionName = "PulsarProxy";
    @FieldContext(category="SASL Authentication Provider", doc="kerberos kinit command.")
    private String kinitCommand = "/usr/bin/kinit";
    @FieldContext(category="RateLimiting", doc="Max concurrent inbound connections. The proxy will reject requests beyond that")
    private int maxConcurrentInboundConnections = 10000;
    @FieldContext(category="RateLimiting", doc="Max concurrent lookup requests. The proxy will reject requests beyond that")
    private int maxConcurrentLookupRequests = 50000;
    @FieldContext(category="Broker Client Authorization", doc="The authentication plugin used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientAuthenticationPlugin;
    @FieldContext(category="Broker Client Authorization", doc="The authentication parameters used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientAuthenticationParameters;
    @FieldContext(category="Broker Client Authorization", doc="The path to trusted certificates used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTrustCertsFilePath;
    @FieldContext(category="Broker Client Authorization", doc="Whether TLS is enabled when communicating with Pulsar brokers")
    private boolean tlsEnabledWithBroker = false;
    @FieldContext(category="Proxy Authorization", doc="When this parameter is not empty, unauthenticated users perform as anonymousUserRole")
    private String anonymousUserRole = null;
    @Deprecated
    private boolean tlsEnabledInProxy = false;
    @FieldContext(category="TLS", doc="Tls cert refresh duration in seconds (set 0 to check on every new connection)")
    private long tlsCertRefreshCheckDurationSec = 300L;
    @FieldContext(category="TLS", doc="Path for the TLS certificate file")
    private String tlsCertificateFilePath;
    @FieldContext(category="TLS", doc="Path for the TLS private key file")
    private String tlsKeyFilePath;
    @FieldContext(category="TLS", doc="Path for the trusted TLS certificate file.\n\nThis cert is used to verify that any certs presented by connecting clients are signed by a certificate authority. If this verification fails, then the certs are untrusted and the connections are dropped")
    private String tlsTrustCertsFilePath;
    @FieldContext(category="TLS", doc="Accept untrusted TLS certificate from client.\n\nIf true, a client with a cert which cannot be verified with the `tlsTrustCertsFilePath` cert will be allowed to connect to the server, though the cert will not be used for client authentication")
    private boolean tlsAllowInsecureConnection = false;
    @FieldContext(category="TLS", doc="Whether the hostname is validated when the proxy creates a TLS connection with brokers")
    private boolean tlsHostnameVerificationEnabled = false;
    @FieldContext(category="TLS", doc="Specify the tls protocols the broker will use to negotiate during TLS handshake (a comma-separated list of protocol names).\n\nExamples:- [TLSv1.2, TLSv1.1, TLSv1]")
    private Set<String> tlsProtocols = Sets.newTreeSet();
    @FieldContext(category="TLS", doc="Specify the tls cipher the proxy will use to negotiate during TLS Handshake (a comma-separated list of ciphers).\n\nExamples:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> tlsCiphers = Sets.newTreeSet();
    @FieldContext(category="TLS", doc="Whether client certificates are required for TLS.\n\n Connections are rejected if the client certificate isn't trusted")
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    @FieldContext(category="KeyStoreTLS", doc="Enable TLS with KeyStore type configuration for proxy")
    private boolean tlsEnabledWithKeyStore = false;
    @FieldContext(category="KeyStoreTLS", doc="TLS Provider")
    private String tlsProvider = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore type configuration for proxy: JKS, PKCS12")
    private String tlsKeyStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore path for proxy")
    private String tlsKeyStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore password for proxy")
    private String tlsKeyStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore type configuration for proxy: JKS, PKCS12")
    private String tlsTrustStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore path for proxy")
    private String tlsTrustStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore password for proxy")
    private String tlsTrustStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="Whether the Pulsar proxy use KeyStore type to authenticate with Pulsar brokers")
    private boolean brokerClientTlsEnabledWithKeyStore = false;
    @FieldContext(category="KeyStoreTLS", doc="The TLS Provider used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientSslProvider = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore type configuration for proxy: JKS, PKCS12  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore path for proxy,  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore password for proxy,  used by the Pulsar proxy to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="Specify the tls cipher the proxy will use to negotiate during TLS Handshake (a comma-separated list of ciphers).\n\nExamples:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256].\n used by the Pulsar proxy to authenticate with Pulsar brokers")
    private Set<String> brokerClientTlsCiphers = Sets.newTreeSet();
    @FieldContext(category="KeyStoreTLS", doc="Specify the tls protocols the broker will use to negotiate during TLS handshake (a comma-separated list of protocol names).\n\nExamples:- [TLSv1.2, TLSv1.1, TLSv1] \n used by the Pulsar proxy to authenticate with Pulsar brokers")
    private Set<String> brokerClientTlsProtocols = Sets.newTreeSet();
    @FieldContext(category="HTTP", doc="Http directs to redirect to non-pulsar services")
    private Set<HttpReverseProxyConfig> httpReverseProxyConfigs = Sets.newHashSet();
    @FieldContext(minValue=1L, category="HTTP", doc="Http output buffer size.\n\nThe amount of data that will be buffered for http requests before it is flushed to the channel. A larger buffer size may result in higher http throughput though it may take longer for the client to see data. If using HTTP streaming via the reverse proxy, this should be set to the minimum value, 1, so that clients see the data as soon as possible.")
    private int httpOutputBufferSize = 32768;
    @FieldContext(minValue=1L, category="HTTP", doc="Number of threads to use for HTTP requests processing")
    private int httpNumThreads = Math.max(8, 2 * Runtime.getRuntime().availableProcessors());
    @FieldContext(category="proxy plugin", doc="The directory to locate proxy additional servlet")
    private String proxyAdditionalServletDirectory = "./proxyAdditionalServlet";
    @FieldContext(category="proxy plugin", doc="List of proxy additional servlet to load, which is a list of proxy additional servlet names")
    private Set<String> proxyAdditionalServlets = Sets.newTreeSet();
    @FieldContext(category="HTTP", doc="Enable the enforcement of limits on the incoming HTTP requests")
    private boolean httpRequestsLimitEnabled = false;
    @FieldContext(category="HTTP", doc="Max HTTP requests per seconds allowed. The excess of requests will be rejected with HTTP code 429 (Too many requests)")
    private double httpRequestsMaxPerSecond = 100.0;
    @FieldContext(category="WebSocket", doc="Enable or disable the WebSocket servlet")
    @PropertiesContext(properties={@PropertyContext(key="tokenPublicKey", doc=@FieldContext(category="Token Authentication Provider", doc="Asymmetric public/private key pair.\n\nConfigure the public key to be used to validate auth tokens The key can be specified like:\n\ntokenPublicKey=data:;base64,xxxxxxxxx\ntokenPublicKey=file:///my/public.key")), @PropertyContext(key="tokenSecretKey", doc=@FieldContext(category="Token Authentication Provider", doc="Symmetric key.\n\nConfigure the secret key to be used to validate auth tokensThe key can be specified like:\n\ntokenSecretKey=data:;base64,xxxxxxxxx\ntokenSecretKey=file:///my/secret.key"))})
    private boolean webSocketServiceEnabled = false;
    @FieldContext(category="WebSocket", doc="Name of the cluster to which this broker belongs to")
    private String clusterName;
    private Properties properties = new Properties();

    public Properties getProperties() {
        return this.properties;
    }

    public Optional<Integer> getServicePort() {
        return this.servicePort;
    }

    public Optional<Integer> getServicePortTls() {
        return this.servicePortTls;
    }

    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        HashMap redirects = new HashMap();
        Pattern redirectPattern = Pattern.compile("^httpReverseProxy\\.([^\\.]*)\\.(.+)$");
        Map<String, List<Matcher>> groups = properties.stringPropertyNames().stream().map(s -> redirectPattern.matcher((CharSequence)s)).filter(Matcher::matches).collect(Collectors.groupingBy(m -> m.group(1)));
        groups.entrySet().forEach(e -> {
            Map<String, String> keyToFullKey = ((List)e.getValue()).stream().collect(Collectors.toMap(m -> m.group(2), m -> m.group(0)));
            if (!keyToFullKey.containsKey("path")) {
                throw new IllegalArgumentException(String.format("httpReverseProxy.%s.path must be specified exactly once", e.getKey()));
            }
            if (!keyToFullKey.containsKey("proxyTo")) {
                throw new IllegalArgumentException(String.format("httpReverseProxy.%s.proxyTo must be specified exactly once", e.getKey()));
            }
            this.httpReverseProxyConfigs.add(new HttpReverseProxyConfig((String)e.getKey(), properties.getProperty(keyToFullKey.get("path")), properties.getProperty(keyToFullKey.get("proxyTo"))));
        });
    }

    public String getZookeeperServers() {
        return this.zookeeperServers;
    }

    public String getConfigurationStoreServers() {
        return this.configurationStoreServers;
    }

    @Deprecated
    public String getGlobalZookeeperServers() {
        return this.globalZookeeperServers;
    }

    public int getZookeeperSessionTimeoutMs() {
        return this.zookeeperSessionTimeoutMs;
    }

    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    public String getBrokerServiceURL() {
        return this.brokerServiceURL;
    }

    public String getBrokerServiceURLTLS() {
        return this.brokerServiceURLTLS;
    }

    public String getBrokerWebServiceURL() {
        return this.brokerWebServiceURL;
    }

    public String getBrokerWebServiceURLTLS() {
        return this.brokerWebServiceURLTLS;
    }

    public String getFunctionWorkerWebServiceURL() {
        return this.functionWorkerWebServiceURL;
    }

    public String getFunctionWorkerWebServiceURLTLS() {
        return this.functionWorkerWebServiceURLTLS;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getAdvertisedAddress() {
        return this.advertisedAddress;
    }

    public boolean isHaProxyProtocolEnabled() {
        return this.haProxyProtocolEnabled;
    }

    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    public Optional<Integer> getProxyLogLevel() {
        return this.proxyLogLevel;
    }

    public String getStatusFilePath() {
        return this.statusFilePath;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public boolean isForwardAuthorizationCredentials() {
        return this.forwardAuthorizationCredentials;
    }

    public boolean isAuthenticateMetricsEndpoint() {
        return this.authenticateMetricsEndpoint;
    }

    public String getSaslJaasClientAllowedIds() {
        return this.saslJaasClientAllowedIds;
    }

    public String getSaslJaasServerSectionName() {
        return this.saslJaasServerSectionName;
    }

    public String getKinitCommand() {
        return this.kinitCommand;
    }

    public int getMaxConcurrentInboundConnections() {
        return this.maxConcurrentInboundConnections;
    }

    public int getMaxConcurrentLookupRequests() {
        return this.maxConcurrentLookupRequests;
    }

    public String getBrokerClientAuthenticationPlugin() {
        return this.brokerClientAuthenticationPlugin;
    }

    public String getBrokerClientAuthenticationParameters() {
        return this.brokerClientAuthenticationParameters;
    }

    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    public boolean isTlsEnabledWithBroker() {
        return this.tlsEnabledWithBroker;
    }

    public String getAnonymousUserRole() {
        return this.anonymousUserRole;
    }

    @Deprecated
    public boolean isTlsEnabledInProxy() {
        return this.tlsEnabledInProxy;
    }

    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsHostnameVerificationEnabled() {
        return this.tlsHostnameVerificationEnabled;
    }

    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    public boolean isTlsEnabledWithKeyStore() {
        return this.tlsEnabledWithKeyStore;
    }

    public String getTlsProvider() {
        return this.tlsProvider;
    }

    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    public String getTlsKeyStore() {
        return this.tlsKeyStore;
    }

    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    public boolean isBrokerClientTlsEnabledWithKeyStore() {
        return this.brokerClientTlsEnabledWithKeyStore;
    }

    public String getBrokerClientSslProvider() {
        return this.brokerClientSslProvider;
    }

    public String getBrokerClientTlsTrustStoreType() {
        return this.brokerClientTlsTrustStoreType;
    }

    public String getBrokerClientTlsTrustStore() {
        return this.brokerClientTlsTrustStore;
    }

    public String getBrokerClientTlsTrustStorePassword() {
        return this.brokerClientTlsTrustStorePassword;
    }

    public Set<String> getBrokerClientTlsCiphers() {
        return this.brokerClientTlsCiphers;
    }

    public Set<String> getBrokerClientTlsProtocols() {
        return this.brokerClientTlsProtocols;
    }

    public Set<HttpReverseProxyConfig> getHttpReverseProxyConfigs() {
        return this.httpReverseProxyConfigs;
    }

    public int getHttpOutputBufferSize() {
        return this.httpOutputBufferSize;
    }

    public int getHttpNumThreads() {
        return this.httpNumThreads;
    }

    public String getProxyAdditionalServletDirectory() {
        return this.proxyAdditionalServletDirectory;
    }

    public Set<String> getProxyAdditionalServlets() {
        return this.proxyAdditionalServlets;
    }

    public boolean isHttpRequestsLimitEnabled() {
        return this.httpRequestsLimitEnabled;
    }

    public double getHttpRequestsMaxPerSecond() {
        return this.httpRequestsMaxPerSecond;
    }

    public boolean isWebSocketServiceEnabled() {
        return this.webSocketServiceEnabled;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setZookeeperServers(String zookeeperServers) {
        this.zookeeperServers = zookeeperServers;
    }

    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    @Deprecated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    public void setZookeeperSessionTimeoutMs(int zookeeperSessionTimeoutMs) {
        this.zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMs;
    }

    public void setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
    }

    public void setBrokerServiceURL(String brokerServiceURL) {
        this.brokerServiceURL = brokerServiceURL;
    }

    public void setBrokerServiceURLTLS(String brokerServiceURLTLS) {
        this.brokerServiceURLTLS = brokerServiceURLTLS;
    }

    public void setBrokerWebServiceURL(String brokerWebServiceURL) {
        this.brokerWebServiceURL = brokerWebServiceURL;
    }

    public void setBrokerWebServiceURLTLS(String brokerWebServiceURLTLS) {
        this.brokerWebServiceURLTLS = brokerWebServiceURLTLS;
    }

    public void setFunctionWorkerWebServiceURL(String functionWorkerWebServiceURL) {
        this.functionWorkerWebServiceURL = functionWorkerWebServiceURL;
    }

    public void setFunctionWorkerWebServiceURLTLS(String functionWorkerWebServiceURLTLS) {
        this.functionWorkerWebServiceURLTLS = functionWorkerWebServiceURLTLS;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setAdvertisedAddress(String advertisedAddress) {
        this.advertisedAddress = advertisedAddress;
    }

    public void setHaProxyProtocolEnabled(boolean haProxyProtocolEnabled) {
        this.haProxyProtocolEnabled = haProxyProtocolEnabled;
    }

    public void setServicePort(Optional<Integer> servicePort) {
        this.servicePort = servicePort;
    }

    public void setServicePortTls(Optional<Integer> servicePortTls) {
        this.servicePortTls = servicePortTls;
    }

    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    public void setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
    }

    public void setProxyLogLevel(Optional<Integer> proxyLogLevel) {
        this.proxyLogLevel = proxyLogLevel;
    }

    public void setStatusFilePath(String statusFilePath) {
        this.statusFilePath = statusFilePath;
    }

    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    public void setForwardAuthorizationCredentials(boolean forwardAuthorizationCredentials) {
        this.forwardAuthorizationCredentials = forwardAuthorizationCredentials;
    }

    public void setAuthenticateMetricsEndpoint(boolean authenticateMetricsEndpoint) {
        this.authenticateMetricsEndpoint = authenticateMetricsEndpoint;
    }

    public void setSaslJaasClientAllowedIds(String saslJaasClientAllowedIds) {
        this.saslJaasClientAllowedIds = saslJaasClientAllowedIds;
    }

    public void setSaslJaasServerSectionName(String saslJaasServerSectionName) {
        this.saslJaasServerSectionName = saslJaasServerSectionName;
    }

    public void setKinitCommand(String kinitCommand) {
        this.kinitCommand = kinitCommand;
    }

    public void setMaxConcurrentInboundConnections(int maxConcurrentInboundConnections) {
        this.maxConcurrentInboundConnections = maxConcurrentInboundConnections;
    }

    public void setMaxConcurrentLookupRequests(int maxConcurrentLookupRequests) {
        this.maxConcurrentLookupRequests = maxConcurrentLookupRequests;
    }

    public void setBrokerClientAuthenticationPlugin(String brokerClientAuthenticationPlugin) {
        this.brokerClientAuthenticationPlugin = brokerClientAuthenticationPlugin;
    }

    public void setBrokerClientAuthenticationParameters(String brokerClientAuthenticationParameters) {
        this.brokerClientAuthenticationParameters = brokerClientAuthenticationParameters;
    }

    public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    public void setTlsEnabledWithBroker(boolean tlsEnabledWithBroker) {
        this.tlsEnabledWithBroker = tlsEnabledWithBroker;
    }

    public void setAnonymousUserRole(String anonymousUserRole) {
        this.anonymousUserRole = anonymousUserRole;
    }

    @Deprecated
    public void setTlsEnabledInProxy(boolean tlsEnabledInProxy) {
        this.tlsEnabledInProxy = tlsEnabledInProxy;
    }

    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }

    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsHostnameVerificationEnabled(boolean tlsHostnameVerificationEnabled) {
        this.tlsHostnameVerificationEnabled = tlsHostnameVerificationEnabled;
    }

    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }

    public void setTlsEnabledWithKeyStore(boolean tlsEnabledWithKeyStore) {
        this.tlsEnabledWithKeyStore = tlsEnabledWithKeyStore;
    }

    public void setTlsProvider(String tlsProvider) {
        this.tlsProvider = tlsProvider;
    }

    public void setTlsKeyStoreType(String tlsKeyStoreType) {
        this.tlsKeyStoreType = tlsKeyStoreType;
    }

    public void setTlsKeyStore(String tlsKeyStore) {
        this.tlsKeyStore = tlsKeyStore;
    }

    public void setTlsKeyStorePassword(String tlsKeyStorePassword) {
        this.tlsKeyStorePassword = tlsKeyStorePassword;
    }

    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    public void setTlsTrustStore(String tlsTrustStore) {
        this.tlsTrustStore = tlsTrustStore;
    }

    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    public void setBrokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
        this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
    }

    public void setBrokerClientSslProvider(String brokerClientSslProvider) {
        this.brokerClientSslProvider = brokerClientSslProvider;
    }

    public void setBrokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
        this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
    }

    public void setBrokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
        this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
    }

    public void setBrokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
        this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
    }

    public void setBrokerClientTlsCiphers(Set<String> brokerClientTlsCiphers) {
        this.brokerClientTlsCiphers = brokerClientTlsCiphers;
    }

    public void setBrokerClientTlsProtocols(Set<String> brokerClientTlsProtocols) {
        this.brokerClientTlsProtocols = brokerClientTlsProtocols;
    }

    public void setHttpReverseProxyConfigs(Set<HttpReverseProxyConfig> httpReverseProxyConfigs) {
        this.httpReverseProxyConfigs = httpReverseProxyConfigs;
    }

    public void setHttpOutputBufferSize(int httpOutputBufferSize) {
        this.httpOutputBufferSize = httpOutputBufferSize;
    }

    public void setHttpNumThreads(int httpNumThreads) {
        this.httpNumThreads = httpNumThreads;
    }

    public void setProxyAdditionalServletDirectory(String proxyAdditionalServletDirectory) {
        this.proxyAdditionalServletDirectory = proxyAdditionalServletDirectory;
    }

    public void setProxyAdditionalServlets(Set<String> proxyAdditionalServlets) {
        this.proxyAdditionalServlets = proxyAdditionalServlets;
    }

    public void setHttpRequestsLimitEnabled(boolean httpRequestsLimitEnabled) {
        this.httpRequestsLimitEnabled = httpRequestsLimitEnabled;
    }

    public void setHttpRequestsMaxPerSecond(double httpRequestsMaxPerSecond) {
        this.httpRequestsMaxPerSecond = httpRequestsMaxPerSecond;
    }

    public void setWebSocketServiceEnabled(boolean webSocketServiceEnabled) {
        this.webSocketServiceEnabled = webSocketServiceEnabled;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public static class HttpReverseProxyConfig {
        private final String name;
        private final String path;
        private final String proxyTo;

        HttpReverseProxyConfig(String name, String path, String proxyTo) {
            this.name = name;
            this.path = path;
            this.proxyTo = proxyTo;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getProxyTo() {
            return this.proxyTo;
        }

        public String toString() {
            return String.format("HttpReverseProxyConfig(%s, path=%s, proxyTo=%s)", this.name, this.path, this.proxyTo);
        }
    }
}

