/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.configuration.VipStatus;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.proxy.server.AdminProxyHandler;
import org.apache.pulsar.proxy.server.BrokerDiscoveryProvider;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyService;
import org.apache.pulsar.proxy.server.WebServer;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletWithClassLoader;
import org.apache.pulsar.proxy.stats.ProxyStats;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketReaderServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class ProxyServiceStarter {
    @Parameter(names={"-c", "--config"}, description="Configuration file path", required=true)
    private String configFile;
    @Parameter(names={"-zk", "--zookeeper-servers"}, description="Local zookeeper connection string")
    private String zookeeperServers = "";
    @Deprecated
    @Parameter(names={"-gzk", "--global-zookeeper-servers"}, description="Global zookeeper connection string")
    private String globalZookeeperServers = "";
    @Parameter(names={"-cs", "--configuration-store-servers"}, description="Configuration store connection string")
    private String configurationStoreServers = "";
    @Parameter(names={"-h", "--help"}, description="Show this help message")
    private boolean help = false;
    private static final Logger log = LoggerFactory.getLogger(ProxyServiceStarter.class);

    public ProxyServiceStarter(String[] args) throws Exception {
        try {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
            Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> System.out.println(String.format("%s [%s] error Uncaught exception in thread %s: %s", dateFormat.format(new Date()), thread.getContextClassLoader(), thread.getName(), exception.getMessage())));
            JCommander jcommander = new JCommander();
            try {
                jcommander.addObject((Object)this);
                jcommander.parse(args);
                if (this.help || StringUtils.isBlank((CharSequence)this.configFile)) {
                    jcommander.usage();
                    return;
                }
            }
            catch (Exception e) {
                jcommander.usage();
                System.exit(-1);
            }
            ProxyConfiguration config = (ProxyConfiguration)PulsarConfigurationLoader.create((String)this.configFile, ProxyConfiguration.class);
            if (!StringUtils.isBlank((CharSequence)this.zookeeperServers)) {
                config.setZookeeperServers(this.zookeeperServers);
            }
            if (!StringUtils.isBlank((CharSequence)this.globalZookeeperServers)) {
                config.setConfigurationStoreServers(this.globalZookeeperServers);
            }
            if (!StringUtils.isBlank((CharSequence)this.configurationStoreServers)) {
                config.setConfigurationStoreServers(this.configurationStoreServers);
            }
            if (StringUtils.isBlank((CharSequence)config.getBrokerServiceURL()) && StringUtils.isBlank((CharSequence)config.getBrokerServiceURLTLS()) || config.isAuthorizationEnabled()) {
                Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getZookeeperServers()) ? 1 : 0) != 0, (Object)"zookeeperServers must be provided");
                Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getConfigurationStoreServers()) ? 1 : 0) != 0, (Object)"configurationStoreServers must be provided");
            }
            if (!config.isTlsEnabledWithBroker() && StringUtils.isBlank((CharSequence)config.getBrokerWebServiceURL()) || config.isTlsEnabledWithBroker() && StringUtils.isBlank((CharSequence)config.getBrokerWebServiceURLTLS())) {
                Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getZookeeperServers()) ? 1 : 0) != 0, (Object)"zookeeperServers must be provided");
            }
            AuthenticationService authenticationService = new AuthenticationService(PulsarConfigurationLoader.convertFrom((PulsarConfiguration)config));
            ProxyService proxyService = new ProxyService(config, authenticationService);
            WebServer server = new WebServer(config, authenticationService);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    proxyService.close();
                    server.stop();
                }
                catch (Exception e) {
                    log.warn("server couldn't stop gracefully {}", (Object)e.getMessage(), (Object)e);
                }
            }));
            proxyService.start();
            DefaultExports.initialize();
            Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return JvmMetrics.getJvmDirectMemoryUsed();
                }
            }, new String[0]).register(CollectorRegistry.defaultRegistry);
            Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return PlatformDependent.maxDirectMemory();
                }
            }, new String[0]).register(CollectorRegistry.defaultRegistry);
            ProxyServiceStarter.addWebServerHandlers(server, config, proxyService, proxyService.getDiscoveryProvider());
            server.start();
        }
        catch (Exception e) {
            log.error("Failed to start pulsar proxy service. error msg " + e.getMessage(), (Throwable)e);
            throw new PulsarServerException((Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        new ProxyServiceStarter(args);
    }

    public static void addWebServerHandlers(WebServer server, ProxyConfiguration config, ProxyService service, BrokerDiscoveryProvider discoveryProvider) throws Exception {
        server.addServlet("/metrics", new ServletHolder(MetricsServlet.class), Collections.emptyList(), config.isAuthenticateMetricsEndpoint());
        server.addRestResources("/", VipStatus.class.getPackage().getName(), "statusFilePath", config.getStatusFilePath());
        server.addRestResources("/proxy-stats", ProxyStats.class.getPackage().getName(), "pulsar-proxy", service);
        AdminProxyHandler adminProxyHandler = new AdminProxyHandler(config, discoveryProvider);
        ServletHolder servletHolder = new ServletHolder((Servlet)adminProxyHandler);
        servletHolder.setInitParameter("preserveHost", "true");
        server.addServlet("/admin", servletHolder);
        server.addServlet("/lookup", servletHolder);
        for (ProxyConfiguration.HttpReverseProxyConfig httpReverseProxyConfig : config.getHttpReverseProxyConfigs()) {
            log.debug("Adding reverse proxy with config {}", (Object)httpReverseProxyConfig);
            ServletHolder proxyHolder = new ServletHolder(ProxyServlet.Transparent.class);
            proxyHolder.setInitParameter("proxyTo", httpReverseProxyConfig.getProxyTo());
            proxyHolder.setInitParameter("prefix", "/");
            server.addServlet(httpReverseProxyConfig.getPath(), proxyHolder);
        }
        if (service != null && service.getProxyAdditionalServlets() != null) {
            Collection<ProxyAdditionalServletWithClassLoader> additionalServletCollection = service.getProxyAdditionalServlets().getServlets().values();
            for (ProxyAdditionalServletWithClassLoader servletWithClassLoader : additionalServletCollection) {
                servletWithClassLoader.loadConfig(config);
                server.addServlet(servletWithClassLoader.getBasePath(), servletWithClassLoader.getServletHolder(), Collections.emptyList(), config.isAuthenticationEnabled());
                log.info("proxy add additional servlet basePath {} ", (Object)servletWithClassLoader.getBasePath());
            }
        }
        if (config.isWebSocketServiceEnabled()) {
            WebSocketService webSocketService = new WebSocketService(null, PulsarConfigurationLoader.convertFrom((PulsarConfiguration)config));
            webSocketService.start();
            WebSocketProducerServlet webSocketProducerServlet = new WebSocketProducerServlet(webSocketService);
            server.addServlet("/ws/producer", new ServletHolder((Servlet)webSocketProducerServlet));
            server.addServlet("/ws/v2/producer", new ServletHolder((Servlet)webSocketProducerServlet));
            WebSocketConsumerServlet consumerWebSocketServlet = new WebSocketConsumerServlet(webSocketService);
            server.addServlet("/ws/consumer", new ServletHolder((Servlet)consumerWebSocketServlet));
            server.addServlet("/ws/v2/consumer", new ServletHolder((Servlet)consumerWebSocketServlet));
            WebSocketReaderServlet readerWebSocketServlet = new WebSocketReaderServlet(webSocketService);
            server.addServlet("/ws/reader", new ServletHolder((Servlet)readerWebSocketServlet));
            server.addServlet("/ws/v2/reader", new ServletHolder((Servlet)readerWebSocketServlet));
        }
    }
}

