/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server.plugin.servlet;

import java.io.IOException;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAdditionalServletWithClassLoader
implements ProxyAdditionalServlet {
    private static final Logger log = LoggerFactory.getLogger(ProxyAdditionalServletWithClassLoader.class);
    private final ProxyAdditionalServlet servlet;
    private final NarClassLoader classLoader;

    @Override
    public void loadConfig(ProxyConfiguration proxyConfiguration) {
        this.servlet.loadConfig(proxyConfiguration);
    }

    @Override
    public String getBasePath() {
        return this.servlet.getBasePath();
    }

    @Override
    public ServletHolder getServletHolder() {
        return this.servlet.getServletHolder();
    }

    @Override
    public void close() {
        this.servlet.close();
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the broker additional servlet class loader", (Throwable)e);
        }
    }

    public ProxyAdditionalServlet getServlet() {
        return this.servlet;
    }

    public NarClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyAdditionalServletWithClassLoader)) {
            return false;
        }
        ProxyAdditionalServletWithClassLoader other = (ProxyAdditionalServletWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProxyAdditionalServlet this$servlet = this.getServlet();
        ProxyAdditionalServlet other$servlet = other.getServlet();
        if (this$servlet == null ? other$servlet != null : !this$servlet.equals(other$servlet)) {
            return false;
        }
        NarClassLoader this$classLoader = this.getClassLoader();
        NarClassLoader other$classLoader = other.getClassLoader();
        return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyAdditionalServletWithClassLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProxyAdditionalServlet $servlet = this.getServlet();
        result = result * 59 + ($servlet == null ? 43 : $servlet.hashCode());
        NarClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        return result;
    }

    public String toString() {
        return "ProxyAdditionalServletWithClassLoader(servlet=" + this.getServlet() + ", classLoader=" + this.getClassLoader() + ")";
    }

    public ProxyAdditionalServletWithClassLoader(ProxyAdditionalServlet servlet, NarClassLoader classLoader) {
        this.servlet = servlet;
        this.classLoader = classLoader;
    }
}

