/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.websocket.WebSocketError;
import org.apache.pulsar.websocket.WebSocketService;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketHandler
extends WebSocketAdapter
implements Closeable {
    protected final WebSocketService service;
    protected final HttpServletRequest request;
    protected final String topic;
    protected final Map<String, String> queryParams;
    private static final Logger log = LoggerFactory.getLogger(AbstractWebSocketHandler.class);

    public AbstractWebSocketHandler(WebSocketService service, HttpServletRequest request) {
        this.service = service;
        this.request = request;
        this.topic = this.extractTopicName(request);
        this.queryParams = new TreeMap<String, String>();
        request.getParameterMap().forEach((key, values) -> this.queryParams.put((String)key, values[0]));
    }

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        log.info("[{}] New WebSocket session on topic {}", (Object)session.getRemoteAddress(), (Object)this.topic);
        String authRole = "<none>";
        if (this.service.isAuthenticationEnabled()) {
            try {
                authRole = this.service.getAuthenticationService().authenticateHttpRequest(this.request);
                log.info("[{}] Authenticated WebSocket client {} on topic {}", new Object[]{session.getRemoteAddress(), authRole, this.topic});
            }
            catch (AuthenticationException e) {
                log.warn("[{}] Failed to authenticated WebSocket client {} on topic {}: {}", new Object[]{session.getRemoteAddress(), authRole, this.topic, e.getMessage()});
                this.close(WebSocketError.AuthenticationError);
                return;
            }
        }
        if (this.service.isAuthorizationEnabled()) {
            try {
                if (!this.isAuthorized(authRole).booleanValue()) {
                    log.warn("[{}] WebSocket Client [{}] is not authorized on topic {}", new Object[]{session.getRemoteAddress(), authRole, this.topic});
                    this.close(WebSocketError.NotAuthorizedError);
                    return;
                }
            }
            catch (Exception e) {
                log.warn("[{}] Got an exception when authorizing WebSocket client {} on topic {} on: {}", new Object[]{session.getRemoteAddress(), authRole, this.topic, e.getMessage()});
                this.close(WebSocketError.UnknownError);
                return;
            }
        }
        this.createClient(session);
    }

    public void onWebSocketError(Throwable cause) {
        super.onWebSocketError(cause);
        log.info("[{}] WebSocket error on topic {} : {}", new Object[]{this.getSession().getRemoteAddress(), this.topic, cause.getMessage()});
        try {
            this.close();
        }
        catch (IOException e) {
            log.error("Failed in closing producer for topic[{}] with error: [{}]: ", (Object)this.topic, (Object)e.getMessage());
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        log.info("[{}] Closed WebSocket session on topic {}. status: {} - reason: {}", new Object[]{this.getSession().getRemoteAddress(), this.topic, statusCode, reason});
        try {
            this.close();
        }
        catch (IOException e) {
            log.warn("[{}] Failed to close handler for topic {}. ", new Object[]{this.getSession().getRemoteAddress(), this.topic, e});
        }
    }

    public void close(WebSocketError error) {
        log.warn("[{}] Closing WebSocket session for topic {} - code: [{}], reason: [{}]", new Object[]{this.getSession().getRemoteAddress(), this.topic, error});
        this.getSession().close(error.getCode(), error.getDescription());
    }

    public void close(WebSocketError error, String message) {
        log.warn("[{}] Closing WebSocket session for topic {} - code: [{}], reason: [{}]", new Object[]{this.getSession().getRemoteAddress(), this.topic, error, message});
        this.getSession().close(error.getCode(), error.getDescription() + ": " + message);
    }

    protected String checkAuthentication() {
        return null;
    }

    private String extractTopicName(HttpServletRequest request) {
        String uri = request.getRequestURI();
        List parts = Splitter.on((String)"/").splitToList((CharSequence)uri);
        Preconditions.checkArgument((parts.size() >= 8 ? 1 : 0) != 0, (Object)"Invalid topic name format");
        Preconditions.checkArgument((boolean)((String)parts.get(1)).equals("ws"));
        Preconditions.checkArgument((boolean)((String)parts.get(3)).equals("persistent"));
        DestinationName dn = DestinationName.get((String)"persistent", (String)((String)parts.get(4)), (String)((String)parts.get(5)), (String)((String)parts.get(6)), (String)((String)parts.get(7)));
        return dn.toString();
    }

    protected abstract Boolean isAuthorized(String var1) throws Exception;

    protected abstract void createClient(Session var1);
}

