/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import com.beust.jcommander.internal.Lists;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationManager;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.client.api.ClientConfiguration;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.websocket.ConsumerHandler;
import org.apache.pulsar.websocket.ProducerHandler;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.apache.pulsar.websocket.stats.ProxyStats;
import org.apache.pulsar.zookeeper.GlobalZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketService
implements Closeable {
    public static final int MaxTextFrameSize = 0x100000;
    AuthenticationService authenticationService;
    AuthorizationManager authorizationManager;
    PulsarClient pulsarClient;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(20, (ThreadFactory)new DefaultThreadFactory("pulsar-websocket"));
    private final OrderedSafeExecutor orderedExecutor = new OrderedSafeExecutor(8, "pulsar-websocket-ordered");
    private GlobalZooKeeperCache globalZkCache;
    private ZooKeeperClientFactory zkClientFactory;
    private ServiceConfiguration config;
    private ConfigurationCacheService configurationCacheService;
    private ClusterData localCluster;
    private final ConcurrentOpenHashMap<String, List<ProducerHandler>> topicProducerMap;
    private final ConcurrentOpenHashMap<String, List<ConsumerHandler>> topicConsumerMap;
    private final ProxyStats proxyStats;
    private static final Logger log = LoggerFactory.getLogger(WebSocketService.class);

    public WebSocketService(WebSocketProxyConfiguration config) {
        this(WebSocketService.createClusterData(config), WebSocketService.createServiceConfiguration(config));
    }

    public WebSocketService(ClusterData localCluster, ServiceConfiguration config) {
        this.config = config;
        this.localCluster = localCluster;
        this.topicProducerMap = new ConcurrentOpenHashMap();
        this.topicConsumerMap = new ConcurrentOpenHashMap();
        this.proxyStats = new ProxyStats(this);
    }

    public void start() throws PulsarServerException, PulsarClientException, MalformedURLException, ServletException, DeploymentException {
        if (StringUtils.isNotBlank((CharSequence)this.config.getGlobalZookeeperServers())) {
            this.globalZkCache = new GlobalZooKeeperCache(this.getZooKeeperClientFactory(), (int)this.config.getZooKeeperSessionTimeoutMillis(), this.config.getGlobalZookeeperServers(), this.orderedExecutor, this.executor);
            try {
                this.globalZkCache.start();
            }
            catch (IOException e) {
                throw new PulsarServerException((Throwable)e);
            }
            this.configurationCacheService = new ConfigurationCacheService(this.getGlobalZkCache());
            log.info("Global Zookeeper cache started");
        }
        if (this.config.isAuthorizationEnabled()) {
            if (this.configurationCacheService == null) {
                throw new PulsarServerException("Failed to initialize authorization manager due to empty GlobalZookeeperServers");
            }
            this.authorizationManager = new AuthorizationManager(this.config, this.configurationCacheService);
        }
        this.authenticationService = new AuthenticationService(this.config);
        log.info("Pulsar WebSocket Service started");
    }

    @Override
    public void close() throws IOException {
        if (this.pulsarClient != null) {
            this.pulsarClient.close();
        }
        if (this.authenticationService != null) {
            this.authenticationService.close();
        }
        if (this.globalZkCache != null) {
            this.globalZkCache.close();
        }
        this.executor.shutdown();
        this.orderedExecutor.shutdown();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public ZooKeeperCache getGlobalZkCache() {
        return this.globalZkCache;
    }

    public ZooKeeperClientFactory getZooKeeperClientFactory() {
        if (this.zkClientFactory == null) {
            this.zkClientFactory = new ZookeeperClientFactoryImpl();
        }
        return this.zkClientFactory;
    }

    public synchronized PulsarClient getPulsarClient() throws IOException {
        if (this.pulsarClient == null) {
            if (this.localCluster == null) {
                this.localCluster = this.retrieveClusterData();
            }
            this.pulsarClient = this.createClientInstance(this.localCluster);
        }
        return this.pulsarClient;
    }

    private PulsarClient createClientInstance(ClusterData clusterData) throws IOException {
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setStatsInterval(0L, TimeUnit.SECONDS);
        clientConf.setUseTls(this.config.isTlsEnabled());
        clientConf.setTlsAllowInsecureConnection(this.config.isTlsAllowInsecureConnection());
        clientConf.setTlsTrustCertsFilePath(this.config.getTlsTrustCertsFilePath());
        clientConf.setIoThreads(this.config.getWebSocketNumIoThreads());
        clientConf.setConnectionsPerBroker(this.config.getWebSocketConnectionsPerBroker());
        if (this.config.isAuthenticationEnabled()) {
            clientConf.setAuthentication(this.config.getBrokerClientAuthenticationPlugin(), this.config.getBrokerClientAuthenticationParameters());
        }
        if (this.config.isTlsEnabled()) {
            if (StringUtils.isNotBlank((CharSequence)clusterData.getBrokerServiceUrlTls())) {
                return PulsarClient.create((String)clusterData.getBrokerServiceUrlTls(), (ClientConfiguration)clientConf);
            }
            if (StringUtils.isNotBlank((CharSequence)clusterData.getServiceUrlTls())) {
                return PulsarClient.create((String)clusterData.getServiceUrlTls(), (ClientConfiguration)clientConf);
            }
        } else if (StringUtils.isNotBlank((CharSequence)clusterData.getBrokerServiceUrl())) {
            return PulsarClient.create((String)clusterData.getBrokerServiceUrl(), (ClientConfiguration)clientConf);
        }
        return PulsarClient.create((String)clusterData.getServiceUrl(), (ClientConfiguration)clientConf);
    }

    private static ClusterData createClusterData(WebSocketProxyConfiguration config) {
        if (StringUtils.isNotBlank((CharSequence)config.getBrokerServiceUrl()) || StringUtils.isNotBlank((CharSequence)config.getBrokerServiceUrlTls())) {
            return new ClusterData(config.getServiceUrl(), config.getServiceUrlTls(), config.getBrokerServiceUrl(), config.getBrokerServiceUrlTls());
        }
        if (StringUtils.isNotBlank((CharSequence)config.getServiceUrl()) || StringUtils.isNotBlank((CharSequence)config.getServiceUrlTls())) {
            return new ClusterData(config.getServiceUrl(), config.getServiceUrlTls());
        }
        return null;
    }

    private static ServiceConfiguration createServiceConfiguration(WebSocketProxyConfiguration config) {
        ServiceConfiguration serviceConfig = new ServiceConfiguration();
        serviceConfig.setClusterName(config.getClusterName());
        serviceConfig.setWebServicePort(config.getWebServicePort());
        serviceConfig.setWebServicePortTls(config.getWebServicePortTls());
        serviceConfig.setAuthenticationEnabled(config.isAuthenticationEnabled());
        serviceConfig.setAuthenticationProviders(config.getAuthenticationProviders());
        serviceConfig.setBrokerClientAuthenticationPlugin(config.getBrokerClientAuthenticationPlugin());
        serviceConfig.setBrokerClientAuthenticationParameters(config.getBrokerClientAuthenticationParameters());
        serviceConfig.setAuthorizationEnabled(config.isAuthorizationEnabled());
        serviceConfig.setAuthorizationAllowWildcardsMatching(config.getAuthorizationAllowWildcardsMatching());
        serviceConfig.setSuperUserRoles(config.getSuperUserRoles());
        serviceConfig.setGlobalZookeeperServers(config.getGlobalZookeeperServers());
        serviceConfig.setZooKeeperSessionTimeoutMillis(config.getZooKeeperSessionTimeoutMillis());
        serviceConfig.setTlsEnabled(config.isTlsEnabled());
        serviceConfig.setTlsTrustCertsFilePath(config.getTlsTrustCertsFilePath());
        serviceConfig.setTlsCertificateFilePath(config.getTlsCertificateFilePath());
        serviceConfig.setTlsKeyFilePath(config.getTlsKeyFilePath());
        serviceConfig.setTlsAllowInsecureConnection(config.isTlsAllowInsecureConnection());
        serviceConfig.setWebSocketNumIoThreads(config.getNumIoThreads());
        serviceConfig.setWebSocketConnectionsPerBroker(config.getConnectionsPerBroker());
        return serviceConfig;
    }

    private ClusterData retrieveClusterData() throws PulsarServerException {
        if (this.configurationCacheService == null) {
            throw new PulsarServerException("Failed to retrieve Cluster data due to empty GlobalZookeeperServers");
        }
        try {
            String path = "/admin/clusters/" + this.config.getClusterName();
            this.localCluster = (ClusterData)this.configurationCacheService.clustersCache().get(path).orElseThrow(() -> new KeeperException.NoNodeException(path));
            return this.localCluster;
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    public ProxyStats getProxyStats() {
        return this.proxyStats;
    }

    public ConfigurationCacheService getConfigurationCache() {
        return this.configurationCacheService;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public boolean isAuthenticationEnabled() {
        if (this.config == null) {
            return false;
        }
        return this.config.isAuthenticationEnabled();
    }

    public boolean isAuthorizationEnabled() {
        if (this.config == null) {
            return false;
        }
        return this.config.isAuthorizationEnabled();
    }

    public boolean addProducer(ProducerHandler producer) {
        return ((List)this.topicProducerMap.computeIfAbsent((Object)producer.getProducer().getTopic(), topic -> Lists.newArrayList())).add(producer);
    }

    public ConcurrentOpenHashMap<String, List<ProducerHandler>> getProducers() {
        return this.topicProducerMap;
    }

    public boolean removeProducer(ProducerHandler producer) {
        String topicName = producer.getProducer().getTopic();
        if (this.topicProducerMap.containsKey((Object)topicName)) {
            return ((List)this.topicProducerMap.get((Object)topicName)).remove(producer);
        }
        return false;
    }

    public boolean addConsumer(ConsumerHandler consumer) {
        return ((List)this.topicConsumerMap.computeIfAbsent((Object)consumer.getConsumer().getTopic(), topic -> Lists.newArrayList())).add(consumer);
    }

    public ConcurrentOpenHashMap<String, List<ConsumerHandler>> getConsumers() {
        return this.topicConsumerMap;
    }

    public boolean removeConsumer(ConsumerHandler consumer) {
        String topicName = consumer.getConsumer().getTopic();
        if (this.topicConsumerMap.containsKey((Object)topicName)) {
            return ((List)this.topicConsumerMap.get((Object)topicName)).remove(consumer);
        }
        return false;
    }

    public ServiceConfiguration getConfig() {
        return this.config;
    }
}

