/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.admin;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.collect.Maps;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.websocket.ConsumerHandler;
import org.apache.pulsar.websocket.ProducerHandler;
import org.apache.pulsar.websocket.admin.RestException;
import org.apache.pulsar.websocket.admin.WebSocketWebResource;
import org.apache.pulsar.websocket.stats.ProxyTopicStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/proxy-stats")
@Api(value="/proxy", description="Stats for web-socket proxy", tags={"proxy-stats"})
@Produces(value={"application/json"})
public class WebSocketProxyStats
extends WebSocketWebResource {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketProxyStats.class);

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Requested should be executed by Monitoring agent on each proxy to fetch the metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Collection<Metrics> getMetrics() throws Exception {
        this.validateSuperUserAccess();
        try {
            return this.service().getProxyStats().getMetrics();
        }
        catch (Exception e) {
            LOG.error("[{}] Failed to generate metrics", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{destination}/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public ProxyTopicStat getStats(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="destination") @Encoded String destination) {
        destination = Codec.decode((String)destination);
        DestinationName dn = DestinationName.get((String)"persistent", (String)property, (String)cluster, (String)namespace, (String)destination);
        this.validateUserAccess(dn);
        ProxyTopicStat stats = this.getStat(dn.toString());
        if (stats == null) {
            throw new RestException(Response.Status.NOT_FOUND, "Topic does not exist");
        }
        return stats;
    }

    @GET
    @Path(value="/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Map<String, ProxyTopicStat> getProxyStats() {
        this.validateSuperUserAccess();
        return this.getStat();
    }

    public ProxyTopicStat getStat(String topicName) {
        if (!this.service().getProducers().containsKey((Object)topicName) && !this.service().getConsumers().containsKey((Object)topicName)) {
            LOG.warn("topic doesn't exist {}", (Object)topicName);
            throw new RestException(Response.Status.NOT_FOUND, "Topic does not exist");
        }
        ProxyTopicStat topicStat = new ProxyTopicStat();
        ((List)this.service().getProducers().get((Object)topicName)).forEach(handler -> {
            ProxyTopicStat.ProducerStats stat = new ProxyTopicStat.ProducerStats((ProducerHandler)handler);
            topicStat.producerStats.add(stat);
        });
        ((List)this.service().getConsumers().get((Object)topicName)).forEach(handler -> topicStat.consumerStats.add(new ProxyTopicStat.ConsumerStats((ConsumerHandler)handler)));
        return topicStat;
    }

    public Map<String, ProxyTopicStat> getStat() {
        HashMap statMap = Maps.newHashMap();
        this.service().getProducers().forEach((topicName, handlers) -> {
            ProxyTopicStat topicStat = statMap.computeIfAbsent(topicName, t -> new ProxyTopicStat());
            handlers.forEach(handler -> topicStat.producerStats.add(new ProxyTopicStat.ProducerStats((ProducerHandler)handler)));
            statMap.put(topicName, topicStat);
        });
        this.service().getConsumers().forEach((topicName, handlers) -> {
            ProxyTopicStat topicStat = statMap.computeIfAbsent(topicName, t -> new ProxyTopicStat());
            handlers.forEach(handler -> topicStat.consumerStats.add(new ProxyTopicStat.ConsumerStats((ConsumerHandler)handler)));
            statMap.put(topicName, topicStat);
        });
        return statMap;
    }
}

