/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import com.google.common.base.Preconditions;
import javax.servlet.Servlet;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.admin.WebSocketProxyStats;
import org.apache.pulsar.websocket.service.ProxyServer;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServiceStarter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServiceStarter.class);

    public static void main(String[] args) throws Exception {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Need to specify a configuration file");
        try {
            String configFile = args[0];
            log.info("Loading configuration from {}", (Object)configFile);
            WebSocketProxyConfiguration config = (WebSocketProxyConfiguration)PulsarConfigurationLoader.create((String)configFile, WebSocketProxyConfiguration.class);
            ProxyServer proxyServer = new ProxyServer(config);
            WebSocketService service = new WebSocketService(config);
            WebSocketServiceStarter.start(proxyServer, service);
        }
        catch (Exception e) {
            log.error("Failed to start WebSocket service", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
    }

    public static void start(ProxyServer proxyServer, WebSocketService service) throws Exception {
        proxyServer.addWebSocketServlet("/ws/producer", (Servlet)new WebSocketProducerServlet(service));
        proxyServer.addWebSocketServlet("/ws/consumer", (Servlet)new WebSocketConsumerServlet(service));
        proxyServer.addRestResources("/admin", WebSocketProxyStats.class.getPackage().getName(), service);
        proxyServer.start();
        service.start();
    }
}

