/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.stats;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.websocket.ProducerHandler;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.stats.JvmMetrics;
import org.apache.pulsar.websocket.stats.StatsBuckets;

public class ProxyStats {
    private final WebSocketService service;
    private final JvmMetrics jvmMetrics;
    private ConcurrentOpenHashMap<String, ProxyNamespaceStats> topicStats;
    private List<Metrics> tempMetricsCollection;
    private List<Metrics> metricsCollection;

    public ProxyStats(WebSocketService service) {
        this.service = service;
        this.jvmMetrics = new JvmMetrics(service);
        this.topicStats = new ConcurrentOpenHashMap();
        this.tempMetricsCollection = Lists.newArrayList();
        this.metricsCollection = Lists.newArrayList();
        service.getExecutor().scheduleAtFixedRate(() -> this.generate(), 120L, 60L, TimeUnit.SECONDS);
    }

    public synchronized void generate() {
        this.topicStats.clear();
        this.service.getProducers().forEach((topic, handlers) -> {
            String namespaceName = DestinationName.get((String)topic).getNamespace();
            ProxyNamespaceStats nsStat = (ProxyNamespaceStats)this.topicStats.computeIfAbsent((Object)namespaceName, ns -> new ProxyNamespaceStats());
            handlers.forEach(handler -> {
                nsStat.numberOfMsgPublished += handler.getAndResetNumMsgsSent();
                nsStat.numberOfBytesPublished += handler.getAndResetNumBytesSent();
                nsStat.numberOfPublishFailure += handler.getAndResetNumMsgsFailed();
                if (nsStat.publishMsgLatency == null) {
                    nsStat.publishMsgLatency = new StatsBuckets(ProducerHandler.ENTRY_LATENCY_BUCKETS_USEC);
                }
                handler.getPublishLatencyStatsUSec().refresh();
                nsStat.publishMsgLatency.addAll(handler.getPublishLatencyStatsUSec());
                System.out.println(nsStat.publishMsgLatency);
            });
        });
        this.service.getConsumers().forEach((topic, handlers) -> {
            String namespaceName = DestinationName.get((String)topic).getNamespace();
            ProxyNamespaceStats nsStat = (ProxyNamespaceStats)this.topicStats.computeIfAbsent((Object)namespaceName, ns -> new ProxyNamespaceStats());
            handlers.forEach(handler -> {
                nsStat.numberOfMsgDelivered += handler.getAndResetNumMsgsAcked();
                nsStat.numberOfBytesDelivered += handler.getAndResetNumBytesDelivered();
                nsStat.numberOfMsgsAcked += handler.getAndResetNumMsgsAcked();
            });
        });
        this.tempMetricsCollection.clear();
        this.topicStats.forEach((namespace, stats) -> this.tempMetricsCollection.add(stats.add((String)namespace)));
        this.tempMetricsCollection.add(this.jvmMetrics.generate());
        List<Metrics> tempRef = this.metricsCollection;
        this.metricsCollection = this.tempMetricsCollection;
        tempRef.clear();
    }

    public synchronized List<Metrics> getMetrics() {
        return this.metricsCollection;
    }

    private static class ProxyNamespaceStats {
        public long numberOfMsgPublished;
        public long numberOfBytesPublished;
        public long numberOfPublishFailure;
        public StatsBuckets publishMsgLatency;
        public long numberOfMsgDelivered;
        public long numberOfBytesDelivered;
        public long numberOfMsgsAcked;

        private ProxyNamespaceStats() {
        }

        public Metrics add(String namespace) {
            this.publishMsgLatency.refresh();
            long[] latencyBuckets = this.publishMsgLatency.getBuckets();
            HashMap dimensionMap = Maps.newHashMap();
            dimensionMap.put("namespace", namespace);
            Metrics dMetrics = Metrics.create((Map)dimensionMap);
            dMetrics.put("ns_msg_publish_rate", (Object)this.numberOfMsgPublished);
            dMetrics.put("ns_byte_publish_rate", (Object)this.numberOfBytesPublished);
            dMetrics.put("ns_msg_failure_rate", (Object)this.numberOfPublishFailure);
            dMetrics.put("ns_msg_deliver_rate", (Object)this.numberOfMsgDelivered);
            dMetrics.put("ns_byte_deliver_rate", (Object)this.numberOfBytesDelivered);
            dMetrics.put("ns_msg_ack_rate", (Object)this.numberOfMsgsAcked);
            for (int i = 0; i < latencyBuckets.length; ++i) {
                String latencyBucket = i >= ProducerHandler.ENTRY_LATENCY_BUCKETS_USEC.length ? ProducerHandler.ENTRY_LATENCY_BUCKETS_USEC[ProducerHandler.ENTRY_LATENCY_BUCKETS_USEC.length - 1] + "_higher" : Long.toString(ProducerHandler.ENTRY_LATENCY_BUCKETS_USEC[i]);
                dMetrics.put("ns_msg_publish_latency_" + latencyBucket, (Object)latencyBuckets[i]);
            }
            return dMetrics;
        }
    }
}

