/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.admin;

import javax.naming.AuthenticationException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.admin.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketWebResource {
    public static final String ATTRIBUTE_PROXY_SERVICE_NAME = "webProxyService";
    public static final String ADMIN_PATH = "/admin";
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;
    @Context
    protected UriInfo uri;
    private WebSocketService socketService;
    private String clientId;
    private static final Logger log = LoggerFactory.getLogger(WebSocketWebResource.class);

    protected WebSocketService service() {
        if (this.socketService == null) {
            this.socketService = (WebSocketService)this.servletContext.getAttribute(ATTRIBUTE_PROXY_SERVICE_NAME);
        }
        return this.socketService;
    }

    public String clientAppId() {
        if (this.clientId != null && this.service().getConfig().isAuthenticationEnabled()) {
            try {
                this.clientId = this.service().getAuthenticationService().authenticateHttpRequest(this.httpRequest);
            }
            catch (AuthenticationException e) {
                throw new RestException(Response.Status.UNAUTHORIZED, "Failed to get clientId from request");
            }
        } else {
            throw new RestException(Response.Status.UNAUTHORIZED, "Failed to get auth data from the request");
        }
        return this.clientId;
    }

    protected void validateSuperUserAccess() {
        if (this.service().getConfig().isAuthenticationEnabled()) {
            String appId = this.clientAppId();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Check super user access: Authenticated: {} -- Role: {}", new Object[]{this.uri.getRequestUri(), this.clientAppId(), appId});
            }
            if (!this.service().getConfig().getSuperUserRoles().contains(appId)) {
                throw new RestException(Response.Status.UNAUTHORIZED, "This operation requires super-user access");
            }
        }
    }

    protected boolean validateUserAccess(DestinationName topic) {
        try {
            this.validateSuperUserAccess();
            return true;
        }
        catch (Exception e) {
            try {
                return this.isAuthorized(topic);
            }
            catch (Exception ne) {
                throw new RestException(ne);
            }
        }
    }

    protected boolean isAuthorized(DestinationName topic) throws Exception {
        if (this.service().isAuthorizationEnabled()) {
            String authRole = this.clientAppId();
            return this.service().getAuthorizationManager().canLookup(topic, authRole);
        }
        return true;
    }
}

