/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.admin;

import javax.naming.AuthenticationException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.admin.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketWebResource {
    public static final String ATTRIBUTE_PROXY_SERVICE_NAME = "webProxyService";
    public static final String ADMIN_PATH = "/admin";
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;
    @Context
    protected UriInfo uri;
    private WebSocketService socketService;
    private String clientId;
    private AuthenticationDataHttps authData;
    private static final Logger log = LoggerFactory.getLogger(WebSocketWebResource.class);

    protected WebSocketService service() {
        if (this.socketService == null) {
            this.socketService = (WebSocketService)this.servletContext.getAttribute(ATTRIBUTE_PROXY_SERVICE_NAME);
        }
        return this.socketService;
    }

    public String clientAppId() {
        if (StringUtils.isBlank((CharSequence)this.clientId)) {
            block4: {
                try {
                    this.clientId = this.service().getAuthenticationService().authenticateHttpRequest(this.httpRequest);
                }
                catch (AuthenticationException e) {
                    if (!this.service().getConfig().isAuthenticationEnabled()) break block4;
                    throw new RestException(Response.Status.UNAUTHORIZED, "Failed to get clientId from request");
                }
            }
            if (StringUtils.isBlank((CharSequence)this.clientId) && this.service().getConfig().isAuthenticationEnabled()) {
                throw new RestException(Response.Status.UNAUTHORIZED, "Failed to get auth data from the request");
            }
        }
        return this.clientId;
    }

    public AuthenticationDataHttps authData() {
        if (this.authData == null) {
            this.authData = new AuthenticationDataHttps(this.httpRequest);
        }
        return this.authData;
    }

    protected void validateSuperUserAccess() {
        if (this.service().getConfig().isAuthenticationEnabled()) {
            String appId = this.clientAppId();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Check super user access: Authenticated: {} -- Role: {}", new Object[]{this.uri.getRequestUri(), this.clientAppId(), appId});
            }
            if (!this.service().getConfig().getSuperUserRoles().contains(appId)) {
                throw new RestException(Response.Status.UNAUTHORIZED, "This operation requires super-user access");
            }
        }
    }

    protected boolean validateUserAccess(DestinationName topic) {
        try {
            this.validateSuperUserAccess();
            return true;
        }
        catch (Exception e) {
            try {
                return this.isAuthorized(topic);
            }
            catch (Exception ne) {
                throw new RestException(ne);
            }
        }
    }

    protected boolean isAuthorized(DestinationName topic) throws Exception {
        if (this.service().isAuthorizationEnabled()) {
            return this.service().getAuthorizationService().canLookup(topic, this.clientAppId(), (AuthenticationDataSource)this.authData());
        }
        return true;
    }
}

