/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.admin;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.apache.pulsar.websocket.ConsumerHandler;
import org.apache.pulsar.websocket.ProducerHandler;
import org.apache.pulsar.websocket.ReaderHandler;
import org.apache.pulsar.websocket.admin.RestException;
import org.apache.pulsar.websocket.admin.WebSocketWebResource;
import org.apache.pulsar.websocket.stats.ProxyTopicStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProxyStatsBase
extends WebSocketWebResource {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketProxyStatsBase.class);

    protected Collection<Metrics> internalGetMetrics() throws Exception {
        this.validateSuperUserAccess();
        try {
            return this.service().getProxyStats().getMetrics();
        }
        catch (Exception e) {
            LOG.error("[{}] Failed to generate metrics", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    protected ProxyTopicStat internalGetStats(TopicName topicName) {
        this.validateUserAccess(topicName);
        ProxyTopicStat stats = this.getStat(topicName);
        if (stats == null) {
            throw new RestException(Response.Status.NOT_FOUND, "Topic does not exist");
        }
        return stats;
    }

    protected Map<String, ProxyTopicStat> internalGetProxyStats() {
        this.validateSuperUserAccess();
        return this.getStat();
    }

    private ProxyTopicStat getStat(TopicName topicName) {
        String topicNameStr = topicName.toString();
        if (!(this.service().getProducers().containsKey((Object)topicNameStr) || this.service().getConsumers().containsKey((Object)topicNameStr) || this.service().getReaders().containsKey((Object)topicNameStr))) {
            LOG.warn("topic doesn't exist {}", (Object)topicNameStr);
            throw new RestException(Response.Status.NOT_FOUND, "Topic does not exist");
        }
        ProxyTopicStat topicStat = new ProxyTopicStat();
        if (this.service().getProducers().containsKey((Object)topicNameStr)) {
            ((ConcurrentOpenHashSet)this.service().getProducers().get((Object)topicNameStr)).forEach(handler -> {
                ProxyTopicStat.ProducerStats stat = new ProxyTopicStat.ProducerStats((ProducerHandler)handler);
                topicStat.producerStats.add(stat);
            });
        }
        if (this.service().getConsumers().containsKey((Object)topicNameStr)) {
            ((ConcurrentOpenHashSet)this.service().getConsumers().get((Object)topicNameStr)).forEach(handler -> topicStat.consumerStats.add(new ProxyTopicStat.ConsumerStats((ConsumerHandler)handler)));
        }
        if (this.service().getReaders().containsKey((Object)topicNameStr)) {
            ((ConcurrentOpenHashSet)this.service().getReaders().get((Object)topicNameStr)).forEach(handler -> topicStat.consumerStats.add(new ProxyTopicStat.ConsumerStats((ReaderHandler)handler)));
        }
        return topicStat;
    }

    public Map<String, ProxyTopicStat> getStat() {
        HashMap statMap = Maps.newHashMap();
        this.service().getProducers().forEach((topicName, handlers) -> {
            ProxyTopicStat topicStat = statMap.computeIfAbsent(topicName, t -> new ProxyTopicStat());
            handlers.forEach(handler -> topicStat.producerStats.add(new ProxyTopicStat.ProducerStats((ProducerHandler)handler)));
            statMap.put(topicName, topicStat);
        });
        this.service().getConsumers().forEach((topicName, handlers) -> {
            ProxyTopicStat topicStat = statMap.computeIfAbsent(topicName, t -> new ProxyTopicStat());
            handlers.forEach(handler -> topicStat.consumerStats.add(new ProxyTopicStat.ConsumerStats((ConsumerHandler)handler)));
            statMap.put(topicName, topicStat);
        });
        this.service().getReaders().forEach((topicName, handlers) -> {
            ProxyTopicStat topicStat = statMap.computeIfAbsent(topicName, t -> new ProxyTopicStat());
            handlers.forEach(handler -> topicStat.consumerStats.add(new ProxyTopicStat.ConsumerStats((ReaderHandler)handler)));
            statMap.put(topicName, topicStat);
        });
        return statMap;
    }
}

