/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.collect.Lists;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer {
    private final Server server;
    private final List<Handler> handlers = Lists.newArrayList();
    private final WebSocketProxyConfiguration conf;
    private final ExecutorService executorService;
    private static final Logger log = LoggerFactory.getLogger(ProxyServer.class);

    public ProxyServer(WebSocketProxyConfiguration config) throws PulsarClientException, MalformedURLException, PulsarServerException {
        this.conf = config;
        this.executorService = Executors.newFixedThreadPool(WebSocketProxyConfiguration.PROXY_SERVER_EXECUTOR_THREADS, (ThreadFactory)new DefaultThreadFactory("pulsar-websocket-web"));
        this.server = new Server((ThreadPool)new ExecutorThreadPool(this.executorService));
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(config.getWebServicePort());
        connectors.add(connector);
        if (config.isTlsEnabled()) {
            try {
                SslContextFactory sslCtxFactory = SecurityUtility.createSslContextFactory((boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustCertsFilePath(), (String)config.getTlsCertificateFilePath(), (String)config.getTlsKeyFilePath(), (boolean)config.getTlsRequireTrustedClientCertOnConnect());
                ServerConnector tlsConnector = new ServerConnector(this.server, -1, -1, sslCtxFactory);
                tlsConnector.setPort(config.getWebServicePortTls());
                connectors.add(tlsConnector);
            }
            catch (GeneralSecurityException e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public void addWebSocketServlet(String basePath, Servlet socketServlet) throws ServletException, DeploymentException {
        ServletHolder servletHolder = new ServletHolder("ws-events", socketServlet);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, "/*");
        this.handlers.add((Handler)context);
    }

    public void addRestResources(String basePath, String javaPackages, String attribute, Object attributeValue) {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(ObjectMapperFactory.create());
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"jersey.config.server.provider.packages", javaPackages});
        config.register((Object)provider);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, "/*");
        context.setAttribute(attribute, attributeValue);
        this.handlers.add((Handler)context);
    }

    public void start() throws PulsarServerException {
        log.info("Starting web socket proxy at port {}", (Object)this.conf.getWebServicePort());
        try {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            Slf4jRequestLog requestLog = new Slf4jRequestLog();
            requestLog.setExtended(true);
            requestLog.setLogTimeZone(TimeZone.getDefault().getID());
            requestLog.setLogLatency(true);
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            this.handlers.add(0, (Handler)new ContextHandlerCollection());
            this.handlers.add((Handler)requestLogHandler);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
            this.server.setHandler((Handler)handlerCollection);
            this.server.start();
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    public void stop() throws Exception {
        this.server.stop();
        this.executorService.shutdown();
    }
}

