/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.configuration.PulsarConfiguration;

public class WebSocketProxyConfiguration
implements PulsarConfiguration {
    public static final int PROXY_SERVER_EXECUTOR_THREADS = 2 * Runtime.getRuntime().availableProcessors();
    public static final int WEBSOCKET_SERVICE_THREADS = 20;
    public static final int GLOBAL_ZK_THREADS = 8;
    @FieldContext(required=true)
    private String clusterName;
    private String serviceUrl;
    private String serviceUrlTls;
    private String brokerServiceUrl;
    private String brokerServiceUrlTls;
    private String statusFilePath;
    @Deprecated
    private String globalZookeeperServers;
    private String configurationStoreServers;
    private long zooKeeperSessionTimeoutMillis = 30000L;
    private int zooKeeperCacheExpirySeconds = 300;
    private Optional<Integer> webServicePort = Optional.of(8080);
    private Optional<Integer> webServicePortTls = Optional.empty();
    private String bindAddress;
    private int webSocketMaxTextFrameSize = 0x100000;
    private boolean authenticationEnabled;
    private Set<String> authenticationProviders = Sets.newTreeSet();
    private boolean authorizationEnabled;
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    private Set<String> superUserRoles = Sets.newTreeSet();
    private boolean authorizationAllowWildcardsMatching = false;
    private String brokerClientAuthenticationPlugin;
    private String brokerClientAuthenticationParameters;
    private String brokerClientTrustCertsFilePath = "";
    private int webSocketNumIoThreads = Runtime.getRuntime().availableProcessors();
    private int numHttpServerThreads = Math.max(6, Runtime.getRuntime().availableProcessors());
    private int webSocketConnectionsPerBroker = Runtime.getRuntime().availableProcessors();
    private int webSocketSessionIdleTimeoutMillis = 300000;
    private String anonymousUserRole = null;
    @Deprecated
    private boolean tlsEnabled = false;
    private boolean brokerClientTlsEnabled = false;
    private String tlsCertificateFilePath;
    private String tlsKeyFilePath;
    private String tlsTrustCertsFilePath = "";
    private boolean tlsAllowInsecureConnection = false;
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    private long tlsCertRefreshCheckDurationSec = 300L;
    private Properties properties = new Properties();

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public void setServiceUrlTls(String serviceUrlTls) {
        this.serviceUrlTls = serviceUrlTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public void setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public String getStatusFilePath() {
        return this.statusFilePath;
    }

    public void setStatusFilePath(String statusFilePath) {
        this.statusFilePath = statusFilePath;
    }

    @Deprecated
    public String getGlobalZookeeperServers() {
        return this.globalZookeeperServers;
    }

    @Deprecated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    public String getConfigurationStoreServers() {
        return null == this.configurationStoreServers ? this.getGlobalZookeeperServers() : this.configurationStoreServers;
    }

    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    public long getZooKeeperSessionTimeoutMillis() {
        return this.zooKeeperSessionTimeoutMillis;
    }

    public void setZooKeeperSessionTimeoutMillis(long zooKeeperSessionTimeoutMillis) {
        this.zooKeeperSessionTimeoutMillis = zooKeeperSessionTimeoutMillis;
    }

    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    public void setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
    }

    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getWebSocketMaxTextFrameSize() {
        return this.webSocketMaxTextFrameSize;
    }

    public void setWebSocketMaxTextFrameSize(int webSocketMaxTextFrameSize) {
        this.webSocketMaxTextFrameSize = webSocketMaxTextFrameSize;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setAuthenticationProviders(Set<String> providersClassNames) {
        this.authenticationProviders = providersClassNames;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    public boolean getAuthorizationAllowWildcardsMatching() {
        return this.authorizationAllowWildcardsMatching;
    }

    public void setAuthorizationAllowWildcardsMatching(boolean authorizationAllowWildcardsMatching) {
        this.authorizationAllowWildcardsMatching = authorizationAllowWildcardsMatching;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    public String getBrokerClientAuthenticationPlugin() {
        return this.brokerClientAuthenticationPlugin;
    }

    public void setBrokerClientAuthenticationPlugin(String brokerClientAuthenticationPlugin) {
        this.brokerClientAuthenticationPlugin = brokerClientAuthenticationPlugin;
    }

    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    public String getBrokerClientAuthenticationParameters() {
        return this.brokerClientAuthenticationParameters;
    }

    public void setBrokerClientAuthenticationParameters(String brokerClientAuthenticationParameters) {
        this.brokerClientAuthenticationParameters = brokerClientAuthenticationParameters;
    }

    @Deprecated
    public int getNumIoThreads() {
        return this.getWebSocketNumIoThreads();
    }

    @Deprecated
    public void setNumIoThreads(int numIoThreads) {
        this.setWebSocketNumIoThreads(numIoThreads);
    }

    public int getWebSocketNumIoThreads() {
        return this.webSocketNumIoThreads;
    }

    public void setWebSocketNumIoThreads(int webSocketNumIoThreads) {
        this.webSocketNumIoThreads = webSocketNumIoThreads;
    }

    public int getNumHttpServerThreads() {
        return this.numHttpServerThreads;
    }

    public void setNumHttpServerThreads(int numHttpServerThreads) {
        this.numHttpServerThreads = numHttpServerThreads;
    }

    @Deprecated
    public int getConnectionsPerBroker() {
        return this.getWebSocketConnectionsPerBroker();
    }

    @Deprecated
    public void setConnectionsPerBroker(int connectionsPerBroker) {
        this.setWebSocketConnectionsPerBroker(connectionsPerBroker);
    }

    public int getWebSocketConnectionsPerBroker() {
        return this.webSocketConnectionsPerBroker;
    }

    public void setWebSocketConnectionsPerBroker(int webSocketConnectionsPerBroker) {
        this.webSocketConnectionsPerBroker = webSocketConnectionsPerBroker;
    }

    public int getWebSocketSessionIdleTimeoutMillis() {
        return this.webSocketSessionIdleTimeoutMillis;
    }

    public void setWebSocketSessionIdleTimeoutMillis(int webSocketSessionIdleTimeoutMillis) {
        this.webSocketSessionIdleTimeoutMillis = webSocketSessionIdleTimeoutMillis;
    }

    public String getAnonymousUserRole() {
        return this.anonymousUserRole;
    }

    public void setAnonymousUserRole(String anonymousUserRole) {
        this.anonymousUserRole = anonymousUserRole;
    }

    public boolean isBrokerClientTlsEnabled() {
        return this.brokerClientTlsEnabled || this.tlsEnabled;
    }

    public void setBrokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean getTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }

    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }
}

