/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.websocket.WebSocketError;
import org.apache.pulsar.websocket.WebSocketService;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketHandler
extends WebSocketAdapter
implements Closeable {
    protected final WebSocketService service;
    protected final HttpServletRequest request;
    protected final TopicName topic;
    protected final Map<String, String> queryParams;
    private static final Logger log = LoggerFactory.getLogger(AbstractWebSocketHandler.class);

    public AbstractWebSocketHandler(WebSocketService service, HttpServletRequest request, ServletUpgradeResponse response) {
        this.service = service;
        this.request = request;
        this.topic = this.extractTopicName(request);
        this.queryParams = new TreeMap<String, String>();
        request.getParameterMap().forEach((key, values) -> this.queryParams.put((String)key, values[0]));
    }

    protected boolean checkAuth(ServletUpgradeResponse response) {
        String authRole = "<none>";
        if (this.service.isAuthenticationEnabled()) {
            try {
                authRole = this.service.getAuthenticationService().authenticateHttpRequest(this.request);
                log.info("[{}:{}] Authenticated WebSocket client {} on topic {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic});
            }
            catch (AuthenticationException e) {
                log.warn("[{}:{}] Failed to authenticated WebSocket client {} on topic {}: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic, e.getMessage()});
                try {
                    response.sendError(401, "Failed to authenticate");
                }
                catch (IOException e1) {
                    log.warn("[{}:{}] Failed to send error: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), e1.getMessage(), e1});
                }
                return false;
            }
        }
        if (this.service.isAuthorizationEnabled()) {
            AuthenticationDataHttps authenticationData = new AuthenticationDataHttps(this.request);
            try {
                if (!this.isAuthorized(authRole, (AuthenticationDataSource)authenticationData).booleanValue()) {
                    log.warn("[{}:{}] WebSocket Client [{}] is not authorized on topic {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic});
                    response.sendError(403, "Not authorized");
                    return false;
                }
            }
            catch (Exception e) {
                log.warn("[{}:{}] Got an exception when authorizing WebSocket client {} on topic {} on: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic, e.getMessage()});
                try {
                    response.sendError(500, "Server error");
                }
                catch (IOException e1) {
                    log.warn("[{}:{}] Failed to send error: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), e1.getMessage(), e1});
                }
                return false;
            }
        }
        return true;
    }

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        log.info("[{}] New WebSocket session on topic {}", (Object)session.getRemoteAddress(), (Object)this.topic);
    }

    public void onWebSocketError(Throwable cause) {
        super.onWebSocketError(cause);
        log.info("[{}] WebSocket error on topic {} : {}", new Object[]{this.getSession().getRemoteAddress(), this.topic, cause.getMessage()});
        try {
            this.close();
        }
        catch (IOException e) {
            log.error("Failed in closing WebSocket session for topic {} with error: {}", (Object)this.topic, (Object)e.getMessage());
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        log.info("[{}] Closed WebSocket session on topic {}. status: {} - reason: {}", new Object[]{this.getSession().getRemoteAddress(), this.topic, statusCode, reason});
        try {
            this.close();
        }
        catch (IOException e) {
            log.warn("[{}] Failed to close handler for topic {}. ", new Object[]{this.getSession().getRemoteAddress(), this.topic, e});
        }
    }

    public void close(WebSocketError error) {
        log.warn("[{}] Closing WebSocket session for topic {} - code: [{}], reason: [{}]", new Object[]{this.getSession().getRemoteAddress(), this.topic, error.getCode(), error.getDescription()});
        this.getSession().close(error.getCode(), error.getDescription());
    }

    public void close(WebSocketError error, String message) {
        log.warn("[{}] Closing WebSocket session for topic {} - code: [{}], reason: [{}]", new Object[]{this.getSession().getRemoteAddress(), this.topic, error.getCode(), error.getDescription() + ": " + message});
        this.getSession().close(error.getCode(), error.getDescription() + ": " + message);
    }

    protected String checkAuthentication() {
        return null;
    }

    private TopicName extractTopicName(HttpServletRequest request) {
        String uri = request.getRequestURI();
        List parts = Splitter.on((String)"/").splitToList((CharSequence)uri);
        Preconditions.checkArgument((parts.size() >= 8 ? 1 : 0) != 0, (Object)"Invalid topic name format");
        Preconditions.checkArgument((boolean)((String)parts.get(1)).equals("ws"));
        boolean isV2Format = ((String)parts.get(2)).equals("v2");
        int domainIndex = isV2Format ? 4 : 3;
        Preconditions.checkArgument((((String)parts.get(domainIndex)).equals("persistent") || ((String)parts.get(domainIndex)).equals("non-persistent") ? 1 : 0) != 0);
        String domain = (String)parts.get(domainIndex);
        NamespaceName namespace = isV2Format ? NamespaceName.get((String)((String)parts.get(5)), (String)((String)parts.get(6))) : NamespaceName.get((String)((String)parts.get(4)), (String)((String)parts.get(5)), (String)((String)parts.get(6)));
        int startPosition = 7;
        boolean isConsumer = "consumer".equals(parts.get(2)) || "consumer".equals(parts.get(3));
        int endPosition = isConsumer ? parts.size() - 1 : parts.size();
        StringBuilder topicName = new StringBuilder((String)parts.get(startPosition));
        while (++startPosition < endPosition) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)parts.get(startPosition)))) continue;
            topicName.append("/").append((String)parts.get(startPosition));
        }
        String name = Codec.decode((String)topicName.toString());
        return TopicName.get((String)domain, (NamespaceName)namespace, (String)name);
    }

    protected abstract Boolean isAuthorized(String var1, AuthenticationDataSource var2) throws Exception;
}

