/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.structuredeventlog;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.pulsar.structuredeventlog.EventResources;

public class EventResourcesImpl
implements EventResources {
    private final EventResourcesImpl parent;
    private List<Object> resources = null;

    public EventResourcesImpl(EventResourcesImpl parent) {
        this.parent = parent;
    }

    @Override
    public EventResources resource(String key, Object value) {
        this.getResources().add(key);
        this.getResources().add(value);
        return this;
    }

    @Override
    public EventResources resource(String key, Supplier<String> value) {
        this.resource(key, (Object)value);
        return this;
    }

    public void copyFrom(EventResourcesImpl other) {
        List<Object> resources = this.getResources();
        if (other.parent != null) {
            this.copyFrom(other.parent);
        }
        if (other.resources != null) {
            resources.addAll(other.resources);
        }
    }

    public void forEach(BiConsumer<String, String> process) {
        if (this.parent != null) {
            this.parent.forEach(process);
        }
        if (this.resources != null) {
            EventResourcesImpl.forEach(this.resources, process);
        }
    }

    private List<Object> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<Object>(2);
        }
        return this.resources;
    }

    public static void forEach(List<Object> list, BiConsumer<String, String> process) {
        for (int i = 0; i < list.size() - 1; i += 2) {
            String key = String.valueOf(list.get(i));
            Object value = list.get(i + 1);
            if (value instanceof Supplier) {
                value = ((Supplier)value).get();
            }
            process.accept(key, String.valueOf(value));
        }
    }
}

