/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Begin;
import org.apache.qpid.protonj2.test.driver.codec.transport.End;

public class DriverSessions {
    public static final int DRIVER_DEFAULT_CHANNEL_MAX = 65535;
    private final Map<UnsignedShort, SessionTracker> localSessions = new LinkedHashMap<UnsignedShort, SessionTracker>();
    private final Map<UnsignedShort, SessionTracker> remoteSessions = new LinkedHashMap<UnsignedShort, SessionTracker>();
    private final AMQPTestDriver driver;
    private UnsignedShort lastRemotelyOpenedSession = null;
    private UnsignedShort lastLocallyOpenedSession = null;
    private LinkTracker lastCoordinator;

    public DriverSessions(AMQPTestDriver driver) {
        this.driver = driver;
    }

    public SessionTracker getLastRemotelyOpenedSession() {
        return this.remoteSessions.get(this.lastRemotelyOpenedSession);
    }

    public SessionTracker getLastLocallyOpenedSession() {
        return this.localSessions.get(this.lastLocallyOpenedSession);
    }

    public LinkTracker getLastOpenedCoordinator() {
        return this.lastCoordinator;
    }

    void setLastOpenedCoordinator(LinkTracker lastOpenedCoordinatorLink) {
        this.lastCoordinator = lastOpenedCoordinatorLink;
    }

    public AMQPTestDriver getDriver() {
        return this.driver;
    }

    public SessionTracker getSessionFromLocalChannel(UnsignedShort localChannel) {
        return this.localSessions.get(localChannel);
    }

    public SessionTracker getSessionFromRemoteChannel(UnsignedShort remoteChannel) {
        return this.remoteSessions.get(remoteChannel);
    }

    public void reset() {
        this.localSessions.clear();
        this.remoteSessions.clear();
        this.lastRemotelyOpenedSession = null;
        this.lastLocallyOpenedSession = null;
        this.lastCoordinator = null;
    }

    public SessionTracker handleBegin(Begin remoteBegin, UnsignedShort remoteChannel) {
        SessionTracker sessionTracker;
        UnsignedShort localChannelMax;
        if (this.remoteSessions.containsKey(remoteChannel)) {
            throw new AssertionError((Object)("Received duplicate Begin for already opened session on channel: " + String.valueOf(remoteChannel)));
        }
        UnsignedShort unsignedShort = this.driver.getLocalOpen() == null ? UnsignedShort.ZERO : (localChannelMax = this.driver.getLocalOpen().getChannelMax() == null ? UnsignedShort.MAX_VALUE : this.driver.getLocalOpen().getChannelMax());
        if (remoteChannel.compareTo(localChannelMax) > 0) {
            throw new AssertionError((Object)("Channel Max [" + String.valueOf(localChannelMax) + "] Exceeded for session Begin: " + String.valueOf(remoteChannel)));
        }
        if (remoteBegin.getRemoteChannel() != null) {
            sessionTracker = this.localSessions.get(remoteBegin.getRemoteChannel());
            if (sessionTracker == null) {
                throw new AssertionError((Object)String.format("Received Begin on channel [%s] that indicated it was a response to a Begin this driver never sent to channel [%s]: ", remoteChannel, remoteBegin.getRemoteChannel()));
            }
        } else {
            sessionTracker = new SessionTracker(this.driver);
        }
        sessionTracker.handleBegin(remoteBegin, remoteChannel);
        this.remoteSessions.put(remoteChannel, sessionTracker);
        this.lastRemotelyOpenedSession = sessionTracker.getRemoteChannel();
        return sessionTracker;
    }

    public SessionTracker handleEnd(End remoteEnd, UnsignedShort remoteChannel) {
        SessionTracker sessionTracker = this.remoteSessions.get(remoteChannel);
        if (sessionTracker == null) {
            throw new AssertionError((Object)String.format("Received End on channel [%s] that has no matching Session for that remote channel. ", remoteChannel));
        }
        sessionTracker.handleEnd(remoteEnd);
        this.remoteSessions.remove(remoteChannel);
        return sessionTracker;
    }

    public SessionTracker handleLocalBegin(Begin localBegin, UnsignedShort localChannel) {
        if (localBegin.getRemoteChannel() != null && this.remoteSessions.containsKey(localBegin.getRemoteChannel())) {
            this.localSessions.put(localChannel, this.remoteSessions.get(localBegin.getRemoteChannel()));
        }
        if (!this.localSessions.containsKey(localChannel)) {
            this.localSessions.put(localChannel, new SessionTracker(this.driver));
        }
        this.lastLocallyOpenedSession = localChannel;
        return this.localSessions.get(localChannel).handleLocalBegin(localBegin, localChannel);
    }

    public SessionTracker handleLocalEnd(End localEnd, UnsignedShort localChannel) {
        if (this.localSessions.containsKey(localChannel)) {
            return this.localSessions.get(localChannel).handleLocalEnd(localEnd);
        }
        return new SessionTracker(this.driver).handleLocalEnd(localEnd);
    }

    public int findFreeLocalChannel() {
        for (int i = 0; i <= 65535; ++i) {
            if (this.localSessions.containsKey(UnsignedShort.valueOf(i))) continue;
            return i;
        }
        throw new IllegalStateException("no local channel available for allocation");
    }

    void freeLocalChannel(UnsignedShort localChannel) {
        this.localSessions.remove(localChannel);
    }
}

