/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.protonj2.test.driver.ScriptWriter;
import org.apache.qpid.protonj2.test.driver.actions.ConnectionDropAction;
import org.apache.qpid.protonj2.test.driver.actions.PeerShutdownAction;

public abstract class ProtonTestPeer
extends ScriptWriter
implements AutoCloseable {
    protected final AtomicBoolean closed = new AtomicBoolean();

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.processPeerShutdownRequest();
        }
    }

    public void dropConnection() {
        if (this.closed.compareAndSet(false, true)) {
            this.processCloseConnectionRequest();
        }
    }

    public void waitForScriptToCompleteIgnoreErrors() {
        this.getDriver().waitForScriptToCompleteIgnoreErrors();
    }

    public void waitForScriptToComplete() {
        this.getDriver().waitForScriptToComplete();
    }

    public void waitForScriptToComplete(long timeout) {
        this.getDriver().waitForScriptToComplete(timeout);
    }

    public void waitForScriptToComplete(long timeout, TimeUnit units) {
        this.getDriver().waitForScriptToComplete(timeout, units);
    }

    public int getEmptyFrameCount() {
        return this.getDriver().getEmptyFrameCount();
    }

    public int getPerformativeCount() {
        return this.getDriver().getPerformativeCount();
    }

    public int getSaslPerformativeCount() {
        return this.getDriver().getSaslPerformativeCount();
    }

    public ProtonTestPeer dropAfterLastHandler() {
        this.getDriver().addScriptedElement(new ConnectionDropAction(this));
        return this;
    }

    public ProtonTestPeer dropAfterLastHandler(int delay) {
        this.getDriver().addScriptedElement(new ConnectionDropAction(this).afterDelay(delay));
        return this;
    }

    public ProtonTestPeer shutdownAfterLastHandler() {
        this.getDriver().addScriptedElement(new PeerShutdownAction(this));
        return this;
    }

    public ProtonTestPeer shutdownAfterLastHandler(int delay) {
        this.getDriver().addScriptedElement(new PeerShutdownAction(this).afterDelay(delay));
        return this;
    }

    protected abstract String getPeerName();

    protected abstract void processCloseConnectionRequest();

    protected abstract void processPeerShutdownRequest();

    protected abstract void processDriverOutput(ByteBuffer var1);

    protected abstract void processConnectionEstablished();

    protected abstract void processConnectionDropped();

    protected void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("The test peer is closed");
        }
    }
}

