/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.ReceiverTracker;
import org.apache.qpid.protonj2.test.driver.SenderTracker;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Attach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Begin;
import org.apache.qpid.protonj2.test.driver.codec.transport.Detach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Disposition;
import org.apache.qpid.protonj2.test.driver.codec.transport.End;
import org.apache.qpid.protonj2.test.driver.codec.transport.Flow;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;
import org.apache.qpid.protonj2.test.driver.codec.transport.Transfer;

public class SessionTracker {
    private final Map<String, LinkTracker> senderByNameMap = new LinkedHashMap<String, LinkTracker>();
    private final Map<String, LinkTracker> receiverByNameMap = new LinkedHashMap<String, LinkTracker>();
    private final Map<UnsignedInteger, LinkTracker> localLinks = new LinkedHashMap<UnsignedInteger, LinkTracker>();
    private final Map<UnsignedInteger, LinkTracker> remoteLinks = new LinkedHashMap<UnsignedInteger, LinkTracker>();
    private UnsignedShort localChannel;
    private UnsignedShort remoteChannel;
    private UnsignedInteger nextIncomingId;
    private UnsignedInteger nextOutgoingId;
    private Begin remoteBegin;
    private Begin localBegin;
    private End remoteEnd;
    private End localEnd;
    private final AMQPTestDriver driver;

    public SessionTracker(AMQPTestDriver driver) {
        this.driver = driver;
    }

    public AMQPTestDriver getDriver() {
        return this.driver;
    }

    public LinkTracker getLastOpenedLink() {
        AtomicReference linkTracker = new AtomicReference();
        this.localLinks.forEach((key, value) -> linkTracker.set(value));
        return (LinkTracker)linkTracker.get();
    }

    public LinkTracker getLastRemotelyOpenedLink() {
        AtomicReference linkTracker = new AtomicReference();
        this.remoteLinks.forEach((key, value) -> linkTracker.set(value));
        return (LinkTracker)linkTracker.get();
    }

    public LinkTracker getLastOpenedCoordinatorLink() {
        AtomicReference linkTracker = new AtomicReference();
        this.localLinks.forEach((key, value) -> {
            if (value.getCoordinator() != null) {
                linkTracker.set(value);
            }
        });
        return (LinkTracker)linkTracker.get();
    }

    public LinkTracker getLastRemotelyOpenedCoordinatorLink() {
        AtomicReference linkTracker = new AtomicReference();
        this.remoteLinks.forEach((key, value) -> {
            if (value.getRemoteCoordinator() != null) {
                linkTracker.set(value);
            }
        });
        return (LinkTracker)linkTracker.get();
    }

    public LinkTracker getLastOpenedRemoteSender() {
        AtomicReference linkTracker = new AtomicReference();
        this.remoteLinks.forEach((key, value) -> {
            if (value.isReceiver()) {
                linkTracker.set(value);
            }
        });
        return (LinkTracker)linkTracker.get();
    }

    public LinkTracker getLastOpenedRemoteReceiver() {
        AtomicReference linkTracker = new AtomicReference();
        this.remoteLinks.forEach((key, value) -> {
            if (value.isSender()) {
                linkTracker.set(value);
            }
        });
        return (LinkTracker)linkTracker.get();
    }

    public LinkTracker getLastOpenedSender() {
        AtomicReference linkTracker = new AtomicReference();
        this.localLinks.forEach((key, value) -> {
            if (value.isSender()) {
                linkTracker.set(value);
            }
        });
        return (LinkTracker)linkTracker.get();
    }

    public LinkTracker getLastOpenedReceiver() {
        AtomicReference linkTracker = new AtomicReference();
        this.localLinks.forEach((key, value) -> {
            if (value.isReceiver()) {
                linkTracker.set(value);
            }
        });
        return (LinkTracker)linkTracker.get();
    }

    public End getRemoteEnd() {
        return this.remoteEnd;
    }

    public End getLocalEnd() {
        return this.localEnd;
    }

    public Begin getRemoteBegin() {
        return this.remoteBegin;
    }

    public Begin getLocalBegin() {
        return this.localBegin;
    }

    public UnsignedShort getRemoteChannel() {
        return this.remoteChannel;
    }

    public UnsignedShort getLocalChannel() {
        return this.localChannel;
    }

    public UnsignedInteger getNextIncomingId() {
        return this.nextIncomingId;
    }

    public UnsignedInteger getNextOutgoingId() {
        return this.nextOutgoingId;
    }

    public SessionTracker handleBegin(Begin remoteBegin, UnsignedShort remoteChannel) {
        this.remoteBegin = remoteBegin;
        this.remoteChannel = remoteChannel;
        this.nextIncomingId = remoteBegin.getNextOutgoingId();
        return this;
    }

    public SessionTracker handleLocalBegin(Begin localBegin, UnsignedShort localChannel) {
        this.localBegin = localBegin;
        this.localChannel = localChannel;
        this.nextOutgoingId = localBegin.getNextOutgoingId();
        return this;
    }

    public SessionTracker handleEnd(End end) {
        this.remoteEnd = end;
        return this;
    }

    public SessionTracker handleLocalEnd(End end) {
        this.localEnd = end;
        return this;
    }

    public LinkTracker handleRemoteAttach(Attach attach) {
        UnsignedInteger localHandleMax;
        LinkTracker linkTracker = this.remoteLinks.get(attach.getHandle());
        if (linkTracker != null) {
            throw new AssertionError((Object)String.format("Received second attach of link handle %s with name %s", attach.getHandle(), attach.getName()));
        }
        UnsignedInteger unsignedInteger = this.localBegin == null ? UnsignedInteger.ZERO : (localHandleMax = this.localBegin.getHandleMax() == null ? UnsignedInteger.MAX_VALUE : this.localBegin.getHandleMax());
        if (attach.getHandle().compareTo(localHandleMax) > 0) {
            throw new AssertionError((Object)("Session Handle Max [" + String.valueOf(localHandleMax) + "] Exceeded for link Attach: " + String.valueOf(attach.getHandle())));
        }
        linkTracker = this.findMatchingPendingLinkOpen(attach);
        if (linkTracker == null) {
            if (attach.getRole().equals(Role.SENDER.getValue())) {
                linkTracker = new ReceiverTracker(this);
                this.receiverByNameMap.put(attach.getName(), linkTracker);
            } else {
                linkTracker = new SenderTracker(this);
                this.senderByNameMap.put(attach.getName(), linkTracker);
            }
        }
        this.remoteLinks.put(attach.getHandle(), linkTracker);
        linkTracker.handlerRemoteAttach(attach);
        if (linkTracker.getRemoteCoordinator() != null) {
            this.getDriver().sessions().setLastOpenedCoordinator(linkTracker);
        }
        return linkTracker;
    }

    public LinkTracker handleLocalAttach(Attach attach) {
        LinkTracker linkTracker = this.localLinks.get(attach.getHandle());
        if (linkTracker == null) {
            if (attach.getRole().equals(Role.SENDER.getValue())) {
                linkTracker = this.senderByNameMap.get(attach.getName());
                if (linkTracker == null) {
                    linkTracker = new SenderTracker(this);
                    this.senderByNameMap.put(attach.getName(), linkTracker);
                }
            } else {
                linkTracker = this.receiverByNameMap.get(attach.getName());
                if (linkTracker == null) {
                    linkTracker = new ReceiverTracker(this);
                    this.receiverByNameMap.put(attach.getName(), linkTracker);
                }
            }
            this.localLinks.put(attach.getHandle(), linkTracker);
            linkTracker.handleLocalAttach(attach);
        }
        return linkTracker;
    }

    public LinkTracker handleRemoteDetach(Detach detach) {
        LinkTracker tracker = this.remoteLinks.get(detach.getHandle());
        if (tracker != null) {
            tracker.handleRemoteDetach(detach);
            this.remoteLinks.remove(detach.getHandle());
            if (tracker.isLocallyDetached()) {
                if (tracker.isSender()) {
                    this.senderByNameMap.remove(tracker.getName());
                } else {
                    this.receiverByNameMap.remove(tracker.getName());
                }
            }
        } else {
            throw new AssertionError((Object)String.format("Received Detach for unknown remote link with handle %s", detach.getHandle()));
        }
        return tracker;
    }

    public LinkTracker handleLocalDetach(Detach detach) {
        LinkTracker tracker = this.localLinks.get(detach.getHandle());
        if (tracker != null) {
            tracker.handleLocalDetach(detach);
            this.localLinks.remove(detach.getHandle());
            if (tracker.isRemotelyDetached()) {
                if (tracker.isSender()) {
                    this.senderByNameMap.remove(tracker.getName());
                } else {
                    this.receiverByNameMap.remove(tracker.getName());
                }
            }
        }
        return tracker;
    }

    public LinkTracker handleTransfer(Transfer transfer, ByteBuffer payload) {
        LinkTracker tracker = this.remoteLinks.get(transfer.getHandle());
        if (tracker.isSender()) {
            throw new AssertionError((Object)"Received inbound Transfer addressed to a local Sender link");
        }
        tracker.handleTransfer(transfer, payload);
        return tracker;
    }

    public void handleLocalTransfer(Transfer transfer, ByteBuffer payload) {
        LinkTracker tracker = this.localLinks.get(transfer.getHandle());
        if (tracker != null && tracker.isSender()) {
            tracker.handleTransfer(transfer, payload);
        }
    }

    public void handleDisposition(Disposition disposition) {
    }

    public void handleLocalDisposition(Disposition disposition) {
    }

    public LinkTracker handleFlow(Flow flow) {
        LinkTracker tracker = null;
        if (flow.getHandle() != null) {
            tracker = this.remoteLinks.get(flow.getHandle());
            if (tracker != null) {
                tracker.handleFlow(flow);
            } else {
                throw new AssertionError((Object)String.format("Received Flow for unknown remote link with handle %s", flow.getHandle()));
            }
        }
        return tracker;
    }

    public UnsignedInteger findFreeLocalHandle() {
        UnsignedInteger HANDLE_MAX = this.localBegin.getHandleMax() != null ? this.localBegin.getHandleMax() : UnsignedInteger.MAX_VALUE;
        for (long i = 0L; i <= HANDLE_MAX.longValue(); ++i) {
            UnsignedInteger handle = UnsignedInteger.valueOf(i);
            if (this.localLinks.containsKey(handle)) continue;
            return handle;
        }
        throw new IllegalStateException("no local handle available for allocation");
    }

    private LinkTracker findMatchingPendingLinkOpen(Attach remoteAttach) {
        for (LinkTracker link : this.senderByNameMap.values()) {
            if (!link.getName().equals(remoteAttach.getName()) || link.isRemotelyAttached() || !remoteAttach.isReceiver()) continue;
            return link;
        }
        for (LinkTracker link : this.receiverByNameMap.values()) {
            if (!link.getName().equals(remoteAttach.getName()) || link.isRemotelyAttached() || !remoteAttach.isSender()) continue;
            return link;
        }
        return null;
    }
}

