/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.AbstractPerformativeInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.messaging.DeleteOnClose;
import org.apache.qpid.protonj2.test.driver.codec.messaging.DeleteOnNoLinks;
import org.apache.qpid.protonj2.test.driver.codec.messaging.DeleteOnNoLinksOrMessages;
import org.apache.qpid.protonj2.test.driver.codec.messaging.DeleteOnNoMessages;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Outcome;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Source;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Target;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusDurability;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusExpiryPolicy;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transactions.Coordinator;
import org.apache.qpid.protonj2.test.driver.codec.transport.Attach;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;
import org.apache.qpid.protonj2.test.driver.codec.transport.SenderSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.matchers.JmsNoLocalByIdDescribedType;
import org.apache.qpid.protonj2.test.driver.matchers.JmsSelectorByIdDescribedType;

public class AttachInjectAction
extends AbstractPerformativeInjectAction<Attach> {
    private final Attach attach = new Attach();
    private boolean explicitlyNullName;
    private boolean explicitlyNullHandle;
    private boolean explicitlyNullDeliveryCount;
    private boolean nullSourceRequired;
    private boolean nullTargetRequired;

    public AttachInjectAction(AMQPTestDriver driver) {
        super(driver);
    }

    @Override
    public Attach getPerformative() {
        return this.attach;
    }

    public boolean isExplicitlyNullName() {
        return this.explicitlyNullName;
    }

    public boolean isExplicitlyNullHandle() {
        return this.explicitlyNullHandle;
    }

    public boolean isExplicitlyNullDeliveryCount() {
        return this.explicitlyNullDeliveryCount;
    }

    public AttachInjectAction withName(String name) {
        this.explicitlyNullName = name == null;
        this.attach.setName(name);
        return this;
    }

    public AttachInjectAction withHandle(int handle) {
        this.attach.setHandle(UnsignedInteger.valueOf(handle));
        return this;
    }

    public AttachInjectAction withHandle(long handle) {
        this.attach.setHandle(UnsignedInteger.valueOf(handle));
        return this;
    }

    public AttachInjectAction withHandle(UnsignedInteger handle) {
        this.explicitlyNullHandle = handle == null;
        this.attach.setHandle(handle);
        return this;
    }

    public AttachInjectAction withRole(boolean role) {
        this.attach.setRole(role);
        return this;
    }

    public AttachInjectAction withRole(Role role) {
        this.attach.setRole(role.getValue());
        return this;
    }

    public AttachInjectAction ofSender() {
        this.attach.setRole(Role.SENDER.getValue());
        return this;
    }

    public AttachInjectAction ofReceiver() {
        this.attach.setRole(Role.RECEIVER.getValue());
        return this;
    }

    public AttachInjectAction withSndSettleMode(byte sndSettleMode) {
        this.attach.setSenderSettleMode(UnsignedByte.valueOf(sndSettleMode));
        return this;
    }

    public AttachInjectAction withSndSettleMode(Byte sndSettleMode) {
        this.attach.setSenderSettleMode(sndSettleMode == null ? null : UnsignedByte.valueOf(sndSettleMode));
        return this;
    }

    public AttachInjectAction withSndSettleMode(SenderSettleMode sndSettleMode) {
        this.attach.setSenderSettleMode(sndSettleMode == null ? null : sndSettleMode.getValue());
        return this;
    }

    public AttachInjectAction withSenderSettleModeMixed() {
        this.attach.setSenderSettleMode(SenderSettleMode.MIXED.getValue());
        return this;
    }

    public AttachInjectAction withSenderSettleModeSettled() {
        this.attach.setSenderSettleMode(SenderSettleMode.SETTLED.getValue());
        return this;
    }

    public AttachInjectAction withSenderSettleModeUnsettled() {
        this.attach.setSenderSettleMode(SenderSettleMode.UNSETTLED.getValue());
        return this;
    }

    public AttachInjectAction withRcvSettleMode(byte rcvSettleMode) {
        this.attach.setReceiverSettleMode(UnsignedByte.valueOf(rcvSettleMode));
        return this;
    }

    public AttachInjectAction withRcvSettleMode(Byte rcvSettleMode) {
        this.attach.setReceiverSettleMode(rcvSettleMode == null ? null : UnsignedByte.valueOf(rcvSettleMode));
        return this;
    }

    public AttachInjectAction withRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        this.attach.setReceiverSettleMode(rcvSettleMode == null ? null : rcvSettleMode.getValue());
        return this;
    }

    public AttachInjectAction withReceivervSettlesFirst() {
        this.attach.setReceiverSettleMode(ReceiverSettleMode.FIRST.getValue());
        return this;
    }

    public AttachInjectAction withReceivervSettlesSecond() {
        this.attach.setReceiverSettleMode(ReceiverSettleMode.SECOND.getValue());
        return this;
    }

    public boolean isNullSourceRequired() {
        return this.nullSourceRequired;
    }

    public AttachInjectAction withNullSource() {
        this.nullSourceRequired = true;
        this.attach.setSource(null);
        return this;
    }

    public SourceBuilder withSource() {
        this.nullSourceRequired = false;
        return new SourceBuilder(this.getOrCreateSource());
    }

    public AttachInjectAction withSource(Source source) {
        this.nullSourceRequired = source == null;
        this.attach.setSource(source);
        return this;
    }

    public boolean isNullTargetRequired() {
        return this.nullTargetRequired;
    }

    public AttachInjectAction withNullTarget() {
        this.nullTargetRequired = true;
        this.attach.setTarget((Target)null);
        return this;
    }

    public TargetBuilder withTarget() {
        this.nullSourceRequired = false;
        return new TargetBuilder(this.getOrCreateTarget());
    }

    public CoordinatorBuilder withCoordinator() {
        this.nullSourceRequired = false;
        return new CoordinatorBuilder(this.getOrCreateCoordinator());
    }

    public AttachInjectAction withTarget(Target target) {
        this.nullTargetRequired = target == null;
        this.attach.setTarget(target);
        return this;
    }

    public AttachInjectAction withTarget(Coordinator coordinator) {
        this.nullTargetRequired = coordinator == null;
        this.attach.setTarget(coordinator);
        return this;
    }

    public AttachInjectAction withUnsettled(Map<Binary, DeliveryState> unsettled) {
        if (unsettled != null) {
            LinkedHashMap<Binary, DescribedType> converted = new LinkedHashMap<Binary, DescribedType>();
            for (Map.Entry<Binary, DeliveryState> entry : unsettled.entrySet()) {
                converted.put(entry.getKey(), entry.getValue());
            }
            this.attach.setUnsettled(converted);
        }
        return this;
    }

    public AttachInjectAction withIncompleteUnsettled(boolean incomplete) {
        this.attach.setIncompleteUnsettled(incomplete);
        return this;
    }

    public AttachInjectAction withNullInitialDeliveryCount() {
        this.attach.setInitialDeliveryCount(null);
        this.explicitlyNullDeliveryCount = true;
        return this;
    }

    public AttachInjectAction withInitialDeliveryCount(long initialDeliveryCount) {
        this.attach.setInitialDeliveryCount(UnsignedInteger.valueOf(initialDeliveryCount));
        return this;
    }

    public AttachInjectAction withMaxMessageSize(UnsignedLong maxMessageSize) {
        this.attach.setMaxMessageSize(maxMessageSize);
        return this;
    }

    public AttachInjectAction withOfferedCapabilities(String ... offeredCapabilities) {
        this.attach.setOfferedCapabilities(TypeMapper.toSymbolArray(offeredCapabilities));
        return this;
    }

    public AttachInjectAction withOfferedCapabilities(Symbol ... offeredCapabilities) {
        this.attach.setOfferedCapabilities(offeredCapabilities);
        return this;
    }

    public AttachInjectAction withDesiredCapabilities(String ... desiredCapabilities) {
        this.attach.setDesiredCapabilities(TypeMapper.toSymbolArray(desiredCapabilities));
        return this;
    }

    public AttachInjectAction withDesiredCapabilities(Symbol ... desiredCapabilities) {
        this.attach.setDesiredCapabilities(desiredCapabilities);
        return this;
    }

    public AttachInjectAction withPropertiesMap(Map<String, Object> properties) {
        this.attach.setProperties(TypeMapper.toSymbolKeyedMap(properties));
        return this;
    }

    public AttachInjectAction withProperties(Map<Symbol, Object> properties) {
        this.attach.setProperties(properties);
        return this;
    }

    public AttachInjectAction withProperty(Symbol key, Object value) {
        if (this.attach.getProperties() == null) {
            this.attach.setProperties(new LinkedHashMap<Symbol, Object>());
        }
        this.attach.getProperties().put(key, value);
        return this;
    }

    public AttachInjectAction withProperty(String key, Object value) {
        return this.withProperty(Symbol.valueOf(key), value);
    }

    @Override
    protected void beforeActionPerformed(AMQPTestDriver driver) {
        if (this.onChannel() == -1) {
            if (driver.sessions().getLastLocallyOpenedSession() == null) {
                throw new AssertionError((Object)"Scripted Action cannot run without a configured channel: No locally opened session exists to auto select a channel.");
            }
            this.onChannel(driver.sessions().getLastLocallyOpenedSession().getLocalChannel().intValue());
        }
        UnsignedShort localChannel = UnsignedShort.valueOf(this.onChannel());
        SessionTracker session = driver.sessions().getSessionFromLocalChannel(localChannel);
        if (session != null) {
            if (this.attach.getName() == null && !this.explicitlyNullName) {
                this.attach.setName(UUID.randomUUID().toString());
            }
            if (this.attach.getHandle() == null && !this.explicitlyNullHandle) {
                this.attach.setHandle(session.findFreeLocalHandle());
            }
            if (this.attach.getHandle() != null) {
                session.handleLocalAttach(this.attach);
            }
        } else if (this.attach.getHandle() == null && !this.explicitlyNullHandle) {
            throw new AssertionError((Object)"Attach must carry a handle or have an explicitly set null handle.");
        }
    }

    private Source getOrCreateSource() {
        if (this.attach.getSource() == null) {
            this.attach.setSource(new Source());
        }
        return this.attach.getSource();
    }

    private Target getOrCreateTarget() {
        if (this.attach.getTarget() == null) {
            this.attach.setTarget(new Target());
        }
        return (Target)this.attach.getTarget();
    }

    private Coordinator getOrCreateCoordinator() {
        if (this.attach.getTarget() == null) {
            this.attach.setTarget(new Coordinator());
        }
        return (Coordinator)this.attach.getTarget();
    }

    public final class SourceBuilder
    extends TerminusBuilder {
        private final Source source;

        public SourceBuilder(Source source) {
            this.source = source;
        }

        public SourceBuilder withAddress(String address) {
            this.source.setAddress(address);
            return this;
        }

        public SourceBuilder withDurabilityOfNone() {
            return this.withDurability(TerminusDurability.NONE);
        }

        public SourceBuilder withDurabilityOfConfiguration() {
            return this.withDurability(TerminusDurability.CONFIGURATION);
        }

        public SourceBuilder withDurabilityOfUnsettledState() {
            return this.withDurability(TerminusDurability.UNSETTLED_STATE);
        }

        public SourceBuilder withDurability(TerminusDurability durability) {
            this.source.setDurable(durability.getValue());
            return this;
        }

        public SourceBuilder withExpiryPolicyOnConnectionClose() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.CONNECTION_CLOSE);
        }

        public SourceBuilder withExpiryPolicyOnSessionEnd() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.SESSION_END);
        }

        public SourceBuilder withExpiryPolicyOnLinkDetach() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }

        public SourceBuilder withExpiryPolicyOfNever() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.NEVER);
        }

        public SourceBuilder withExpiryPolicy(TerminusExpiryPolicy expiryPolicy) {
            this.source.setExpiryPolicy(expiryPolicy.getPolicy());
            return this;
        }

        public SourceBuilder withTimeout(int timeout) {
            this.source.setTimeout(UnsignedInteger.valueOf(timeout));
            return this;
        }

        public SourceBuilder withTimeout(long timeout) {
            this.source.setTimeout(UnsignedInteger.valueOf(timeout));
            return this;
        }

        public SourceBuilder withTimeout(UnsignedInteger timeout) {
            this.source.setTimeout(timeout);
            return this;
        }

        public SourceBuilder withDynamic(boolean dynamic) {
            this.source.setDynamic(dynamic);
            return this;
        }

        public SourceBuilder withDynamic(Boolean dynamic) {
            this.source.setDynamic(dynamic);
            return this;
        }

        public SourceBuilder withDynamicNodePropertiesMap(Map<Symbol, Object> properties) {
            this.source.setDynamicNodeProperties(properties);
            return this;
        }

        public SourceBuilder withDynamicNodeProperties(Map<String, Object> properties) {
            this.source.setDynamicNodeProperties(TypeMapper.toSymbolKeyedMap(properties));
            return this;
        }

        public SourceBuilder withDynamicNodeProperty(String key, Object value) {
            return this.withDynamicNodeProperty(Symbol.valueOf(key), value);
        }

        public SourceBuilder withDynamicNodeProperty(Symbol key, Object value) {
            if (this.source.getDynamicNodeProperties() == null) {
                this.source.setDynamicNodeProperties(new LinkedHashMap<Symbol, Object>());
            }
            this.source.getDynamicNodeProperties().put(key, value);
            return this;
        }

        public SourceBuilder withLifetimePolicyOfDeleteOnClose() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnClose());
        }

        public SourceBuilder withLifetimePolicyOfDeleteOnNoLinks() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnNoLinks());
        }

        public SourceBuilder withLifetimePolicyOfDeleteOnNoLinksOrMessages() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnNoLinksOrMessages());
        }

        public SourceBuilder withLifetimePolicyOfDeleteOnNoNoMessages() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnNoMessages());
        }

        public SourceBuilder withDistributionModeOfCopy() {
            return this.withDistributionMode("COPY");
        }

        public SourceBuilder withDistributionModeOfMove() {
            return this.withDistributionMode("MOVE");
        }

        public SourceBuilder withDistributionMode(String mode) {
            this.source.setDistributionMode(Symbol.valueOf(mode));
            return this;
        }

        public SourceBuilder withDistributionMode(Symbol mode) {
            this.source.setDistributionMode(mode);
            return this;
        }

        public SourceBuilder withJMSSelector(String selector) {
            JmsSelectorByIdDescribedType jmsSelector = new JmsSelectorByIdDescribedType(selector);
            HashMap<String, Object> filters = new HashMap<String, Object>();
            filters.put("jms-selector", jmsSelector);
            return this.withFilterMap(filters);
        }

        public SourceBuilder withNoLocal() {
            JmsNoLocalByIdDescribedType noLocal = new JmsNoLocalByIdDescribedType();
            HashMap<String, Object> filters = new HashMap<String, Object>();
            filters.put("no-local", noLocal);
            return this.withFilterMap(filters);
        }

        public SourceBuilder withFilter(Map<Symbol, Object> filters) {
            this.source.setFilter(filters);
            return this;
        }

        public SourceBuilder withFilterMap(Map<String, Object> filters) {
            this.source.setFilter(TypeMapper.toSymbolKeyedMap(filters));
            return this;
        }

        public SourceBuilder withFilterMap(String key, Object value) {
            return this.withFilterMap(Symbol.valueOf(key), value);
        }

        public SourceBuilder withFilterMap(Symbol key, Object value) {
            if (this.source.getFilter() == null) {
                this.source.setFilter(new LinkedHashMap<Symbol, Object>());
            }
            this.source.getFilter().put(key, value);
            return this;
        }

        public SourceBuilder withDefaultOutcome(Outcome outcome) {
            this.source.setDefaultOutcome((DescribedType)((Object)outcome));
            return this;
        }

        public SourceBuilder withOutcomes(Symbol ... outcomes) {
            this.source.setOutcomes(outcomes);
            return this;
        }

        public SourceBuilder withOutcomes(String ... outcomes) {
            this.source.setOutcomes(outcomes);
            return this;
        }

        public SourceBuilder withCapabilities(Symbol ... capabilities) {
            this.source.setCapabilities(capabilities);
            return this;
        }

        public SourceBuilder withCapabilities(String ... capabilities) {
            this.source.setCapabilities(capabilities);
            return this;
        }
    }

    public final class TargetBuilder
    extends TerminusBuilder {
        private final Target target;

        public TargetBuilder(Target target) {
            this.target = target;
        }

        public TargetBuilder withAddress(String address) {
            this.target.setAddress(address);
            return this;
        }

        public TargetBuilder withDurabilityOfNone() {
            return this.withDurability(TerminusDurability.NONE);
        }

        public TargetBuilder withDurabilityOfConfiguration() {
            return this.withDurability(TerminusDurability.CONFIGURATION);
        }

        public TargetBuilder withDurabilityOfUnsettledState() {
            return this.withDurability(TerminusDurability.UNSETTLED_STATE);
        }

        public TargetBuilder withDurability(TerminusDurability durability) {
            this.target.setDurable(durability.getValue());
            return this;
        }

        public TargetBuilder withExpiryPolicyOnConnectionClose() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.CONNECTION_CLOSE);
        }

        public TargetBuilder withExpiryPolicyOnSessionEnd() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.SESSION_END);
        }

        public TargetBuilder withExpiryPolicyOnLinkDetach() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }

        public TargetBuilder withExpiryPolicyOfNever() {
            return this.withExpiryPolicy(TerminusExpiryPolicy.NEVER);
        }

        public TargetBuilder withExpiryPolicy(TerminusExpiryPolicy expiryPolicy) {
            this.target.setExpiryPolicy(expiryPolicy.getPolicy());
            return this;
        }

        public TargetBuilder withTimeout(int timeout) {
            this.target.setTimeout(UnsignedInteger.valueOf(timeout));
            return this;
        }

        public TargetBuilder withTimeout(long timeout) {
            this.target.setTimeout(UnsignedInteger.valueOf(timeout));
            return this;
        }

        public TargetBuilder withTimeout(UnsignedInteger timeout) {
            this.target.setTimeout(timeout);
            return this;
        }

        public TargetBuilder withDynamic(boolean dynamic) {
            this.target.setDynamic(dynamic);
            return this;
        }

        public TargetBuilder withDynamic(Boolean dynamic) {
            this.target.setDynamic(dynamic);
            return this;
        }

        public TargetBuilder withDynamicNodePropertiesMap(Map<Symbol, Object> properties) {
            this.target.setDynamicNodeProperties(properties);
            return this;
        }

        public TargetBuilder withDynamicNodeProperties(Map<String, Object> properties) {
            this.target.setDynamicNodeProperties(TypeMapper.toSymbolKeyedMap(properties));
            return this;
        }

        public TargetBuilder withDynamicNodeProperty(String key, Object value) {
            return this.withDynamicNodeProperty(Symbol.valueOf(key), value);
        }

        public TargetBuilder withDynamicNodeProperty(Symbol key, Object value) {
            if (this.target.getDynamicNodeProperties() == null) {
                this.target.setDynamicNodeProperties(new LinkedHashMap<Symbol, Object>());
            }
            this.target.getDynamicNodeProperties().put(key, value);
            return this;
        }

        public TargetBuilder withLifetimePolicyOfDeleteOnClose() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnClose());
        }

        public TargetBuilder withLifetimePolicyOfDeleteOnNoLinks() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnNoLinks());
        }

        public TargetBuilder withLifetimePolicyOfDeleteOnNoLinksOrMessages() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnNoLinksOrMessages());
        }

        public TargetBuilder withLifetimePolicyOfDeleteOnNoNoMessages() {
            return this.withDynamicNodeProperty("lifetime-policy", (Object)new DeleteOnNoMessages());
        }

        public TargetBuilder withCapabilities(String ... capabilities) {
            this.target.setCapabilities(TypeMapper.toSymbolArray(capabilities));
            return this;
        }

        public TargetBuilder withCapabilities(Symbol ... capabilities) {
            this.target.setCapabilities(capabilities);
            return this;
        }
    }

    public final class CoordinatorBuilder
    extends TerminusBuilder {
        private final Coordinator coordinator;

        public CoordinatorBuilder(Coordinator coordinator) {
            this.coordinator = coordinator;
        }

        public CoordinatorBuilder withCapabilities(String ... capabilities) {
            this.coordinator.setCapabilities(TypeMapper.toSymbolArray(capabilities));
            return this;
        }

        public CoordinatorBuilder withCapabilities(Symbol ... capabilities) {
            this.coordinator.setCapabilities(capabilities);
            return this;
        }
    }

    protected abstract class TerminusBuilder {
        protected TerminusBuilder() {
        }

        public AttachInjectAction also() {
            return AttachInjectAction.this;
        }

        public AttachInjectAction and() {
            return AttachInjectAction.this;
        }
    }
}

