/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class ByteElement
extends AtomicElement<Byte> {
    private final byte value;

    ByteElement(Element<?> parent, Element<?> prev, byte b) {
        super(parent, prev);
        this.value = b;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 1 : 2;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.BYTE;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            if (this.isElementOfArray()) {
                output.writeByte(this.value);
                return 1;
            }
            output.writeByte(81);
            output.writeByte(this.value);
            return 2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

