/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class IntegerElement
extends AtomicElement<Integer> {
    private final int value;

    IntegerElement(Element<?> parent, Element<?> prev, int i) {
        super(parent, prev);
        this.value = i;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (-128 <= this.value && this.value <= 127) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
                return 4;
            }
            return 4;
        }
        return -128 <= this.value && this.value <= 127 ? 2 : 5;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.INT;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            switch (size) {
                case 2: {
                    output.writeByte(84);
                }
                case 1: {
                    output.writeByte((byte)this.value);
                    break;
                }
                case 5: {
                    output.writeByte(113);
                }
                case 4: {
                    output.writeInt(this.value);
                }
            }
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

