/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class UUIDElement
extends AtomicElement<UUID> {
    private final UUID value;

    UUIDElement(Element<?> parent, Element<?> prev, UUID u) {
        super(parent, prev);
        this.value = u;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 16 : 17;
    }

    @Override
    public UUID getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.UUID;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            if (size == 17) {
                output.writeByte(-104);
            }
            output.writeLong(this.value.getMostSignificantBits());
            output.writeLong(this.value.getLeastSignificantBits());
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

