/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec.transport;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class AMQPHeader {
    static final byte[] PREFIX = new byte[]{65, 77, 81, 80};
    public static final int PROTOCOL_ID_INDEX = 4;
    public static final int MAJOR_VERSION_INDEX = 5;
    public static final int MINOR_VERSION_INDEX = 6;
    public static final int REVISION_INDEX = 7;
    public static final byte AMQP_PROTOCOL_ID = 0;
    public static final byte SASL_PROTOCOL_ID = 3;
    public static final int HEADER_SIZE_BYTES = 8;
    private static final AMQPHeader AMQP_HEADER = new AMQPHeader(new byte[]{65, 77, 81, 80, 0, 1, 0, 0});
    private static final AMQPHeader SASL_HEADER = new AMQPHeader(new byte[]{65, 77, 81, 80, 3, 1, 0, 0});
    private byte[] buffer;

    public AMQPHeader() {
        this(AMQPHeader.AMQP_HEADER.buffer);
    }

    public AMQPHeader(byte[] headerBytes) {
        this.setBuffer(Arrays.copyOf(headerBytes, headerBytes.length), true);
    }

    public AMQPHeader(byte[] headerBytes, boolean validate) {
        this.setBuffer(Arrays.copyOf(headerBytes, headerBytes.length), validate);
    }

    public AMQPHeader(ByteBuffer buffer) {
        ByteBuffer duplicate = ByteBuffer.allocate(8);
        buffer.get(duplicate.array(), 0, 8);
        this.setBuffer(duplicate.array(), true);
    }

    public AMQPHeader(ByteBuffer buffer, boolean validate) {
        ByteBuffer duplicate = ByteBuffer.allocate(8);
        buffer.get(duplicate.array(), 0, 8);
        this.setBuffer(duplicate.array(), validate);
    }

    public static AMQPHeader getAMQPHeader() {
        return AMQP_HEADER;
    }

    public static AMQPHeader getSASLHeader() {
        return SASL_HEADER;
    }

    public int getProtocolId() {
        return this.buffer[4] & 0xFF;
    }

    public int getMajor() {
        return this.buffer[5] & 0xFF;
    }

    public int getMinor() {
        return this.buffer[6] & 0xFF;
    }

    public int getRevision() {
        return this.buffer[7] & 0xFF;
    }

    public byte[] getBuffer() {
        return Arrays.copyOf(this.buffer, this.buffer.length);
    }

    public byte[] toArray() {
        if (this.buffer != null) {
            return Arrays.copyOf(this.buffer, this.buffer.length);
        }
        return null;
    }

    public ByteBuffer toByteBuffer() {
        if (this.buffer != null) {
            return ByteBuffer.wrap(this.toArray());
        }
        return null;
    }

    public byte getByteAt(int i) {
        return this.buffer[i];
    }

    public boolean hasValidPrefix() {
        return this.startsWith(this.buffer, PREFIX);
    }

    public boolean isSaslHeader() {
        return this.getProtocolId() == 3;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buffer == null ? 0 : Arrays.hashCode(this.buffer));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AMQPHeader other = (AMQPHeader)obj;
        if (this.buffer == null && other.buffer != null) {
            return false;
        }
        return Arrays.equals(this.buffer, other.buffer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.buffer.length; ++i) {
            char value = (char)this.buffer[i];
            if (Character.isLetter(value)) {
                builder.append(value);
                continue;
            }
            builder.append(",");
            builder.append((int)value);
        }
        return builder.toString();
    }

    private boolean startsWith(byte[] buffer, byte[] value) {
        if (buffer == null || buffer.length < value.length) {
            return false;
        }
        for (int i = 0; i < value.length; ++i) {
            if (buffer[i] == value[i]) continue;
            return false;
        }
        return true;
    }

    private AMQPHeader setBuffer(byte[] buffer, boolean validate) {
        if (validate) {
            if (buffer.length != 8 || !this.startsWith(buffer, PREFIX)) {
                throw new IllegalArgumentException("Not an AMQP header buffer");
            }
            AMQPHeader.validateProtocolByte(buffer[4]);
            AMQPHeader.validateMajorVersionByte(buffer[5]);
            AMQPHeader.validateMinorVersionByte(buffer[6]);
            AMQPHeader.validateRevisionByte(buffer[7]);
        }
        if (buffer.length > 8) {
            throw new IndexOutOfBoundsException("Buffer is to large to be an AMQP Header value");
        }
        this.buffer = buffer;
        return this;
    }

    public static void validateByte(int index, byte value) {
        switch (index) {
            case 0: {
                AMQPHeader.validatePrefixByte1(value);
                break;
            }
            case 1: {
                AMQPHeader.validatePrefixByte2(value);
                break;
            }
            case 2: {
                AMQPHeader.validatePrefixByte3(value);
                break;
            }
            case 3: {
                AMQPHeader.validatePrefixByte4(value);
                break;
            }
            case 4: {
                AMQPHeader.validateProtocolByte(value);
                break;
            }
            case 5: {
                AMQPHeader.validateMajorVersionByte(value);
                break;
            }
            case 6: {
                AMQPHeader.validateMinorVersionByte(value);
                break;
            }
            case 7: {
                AMQPHeader.validateRevisionByte(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid AMQP Header byte index provided to validation method: " + index);
            }
        }
    }

    private static void validatePrefixByte1(byte value) {
        if (value != PREFIX[0]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(1) specified %d : expected %d", value, PREFIX[0]));
        }
    }

    private static void validatePrefixByte2(byte value) {
        if (value != PREFIX[1]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(2) specified %d : expected %d", value, PREFIX[1]));
        }
    }

    private static void validatePrefixByte3(byte value) {
        if (value != PREFIX[2]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(3) specified %d : expected %d", value, PREFIX[2]));
        }
    }

    private static void validatePrefixByte4(byte value) {
        if (value != PREFIX[3]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(4) specified %d : expected %d", value, PREFIX[3]));
        }
    }

    private static void validateProtocolByte(byte value) {
        if (value != 0 && value != 3) {
            throw new IllegalArgumentException(String.format("Invalid protocol Id specified %d : expected one of %d or %d", value, (byte)0, (byte)3));
        }
    }

    private static void validateMajorVersionByte(byte value) {
        if (value != 1) {
            throw new IllegalArgumentException(String.format("Invalid Major version specified %d : expected %d", value, 1));
        }
    }

    private static void validateMinorVersionByte(byte value) {
        if (value != 0) {
            throw new IllegalArgumentException(String.format("Invalid Minor version specified %d : expected %d", value, 0));
        }
    }

    private static void validateRevisionByte(byte value) {
        if (value != 0) {
            throw new IllegalArgumentException(String.format("Invalid revision specified %d : expected %d", value, 0));
        }
    }

    public <E> void invoke(HeaderHandler<E> handler, E context) {
        if (this.isSaslHeader()) {
            handler.handleSASLHeader(this, context);
        } else {
            handler.handleAMQPHeader(this, context);
        }
    }

    public static interface HeaderHandler<E> {
        default public void handleAMQPHeader(AMQPHeader header, E context) {
        }

        default public void handleSASLHeader(AMQPHeader header, E context) {
        }
    }
}

