/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ScriptedExpectation;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslChallenge;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslInit;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslMechanisms;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslOutcome;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslResponse;
import org.apache.qpid.protonj2.test.driver.codec.transport.AMQPHeader;
import org.apache.qpid.protonj2.test.driver.codec.transport.Attach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Begin;
import org.apache.qpid.protonj2.test.driver.codec.transport.Close;
import org.apache.qpid.protonj2.test.driver.codec.transport.Detach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Disposition;
import org.apache.qpid.protonj2.test.driver.codec.transport.End;
import org.apache.qpid.protonj2.test.driver.codec.transport.Flow;
import org.apache.qpid.protonj2.test.driver.codec.transport.HeartBeat;
import org.apache.qpid.protonj2.test.driver.codec.transport.Open;
import org.apache.qpid.protonj2.test.driver.codec.transport.Transfer;
import org.apache.qpid.protonj2.test.driver.exceptions.UnexpectedPerformativeError;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExpectation<T extends ListDescribedType>
implements ScriptedExpectation {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPTestDriver.class);
    public static int ANY_CHANNEL = -1;
    protected final AMQPTestDriver driver;
    protected int expectedChannel = ANY_CHANNEL;
    private UnsignedInteger frameSize;
    private boolean optional;
    private Predicate<T> verificationPredicate;
    private Consumer<T> performativeCapture;

    public AbstractExpectation(AMQPTestDriver driver) {
        this.driver = driver;
    }

    public AbstractExpectation<T> onChannel(int channel) {
        this.expectedChannel = channel;
        return this;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public AbstractExpectation<T> optional() {
        this.optional = true;
        return this;
    }

    public AbstractExpectation<T> withFrameSize(int frameSize) {
        this.frameSize = new UnsignedInteger(frameSize);
        return this;
    }

    public AbstractExpectation<T> withPredicate(Predicate<T> predicate) {
        this.verificationPredicate = predicate;
        return this;
    }

    public AbstractExpectation<T> withCapture(Consumer<T> capture) {
        this.performativeCapture = capture;
        return this;
    }

    protected final void verifyPerformative(T performative) throws AssertionError {
        LOG.debug("About to check the fields of the performative.\n  Received:" + String.valueOf(performative) + "\n  Expectations: " + String.valueOf(this.getExpectationMatcher()));
        MatcherAssert.assertThat((String)"Performative does not match expectation", performative, this.getExpectationMatcher());
    }

    protected final void verifyPayload(ByteBuffer payload) {
        if (this.getPayloadMatcher() != null) {
            MatcherAssert.assertThat((String)"Payload does not match expectation", (Object)payload, this.getPayloadMatcher());
        } else if (payload != null) {
            throw new AssertionError((Object)"Performative should not have been sent with a payload: ");
        }
    }

    protected final void verifyChannel(int channel) {
        if (this.expectedChannel != ANY_CHANNEL && this.expectedChannel != channel) {
            throw new AssertionError((Object)("Expected send on channel + " + this.expectedChannel + ": but was on channel:" + channel));
        }
    }

    protected final void verifyFrameSize(int frameSize) {
        if (this.frameSize != null && !this.frameSize.equals(UnsignedInteger.valueOf(frameSize))) {
            throw new AssertionError((Object)String.format("Expected frame size %s did not match that of the received frame: %d", this.frameSize, frameSize));
        }
    }

    protected abstract Matcher<ListDescribedType> getExpectationMatcher();

    protected abstract Class<T> getExpectedTypeClass();

    protected Matcher<ByteBuffer> getPayloadMatcher() {
        return null;
    }

    @Override
    public void handleOpen(int frameSize, Open open, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, open, payload, channel, context);
    }

    @Override
    public void handleBegin(int frameSize, Begin begin, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, begin, payload, channel, context);
    }

    @Override
    public void handleAttach(int frameSize, Attach attach, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, attach, payload, channel, context);
    }

    @Override
    public void handleFlow(int frameSize, Flow flow, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, flow, payload, channel, context);
    }

    @Override
    public void handleTransfer(int frameSize, Transfer transfer, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, transfer, payload, channel, context);
    }

    @Override
    public void handleDisposition(int frameSize, Disposition disposition, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, disposition, payload, channel, context);
    }

    @Override
    public void handleDetach(int frameSize, Detach detach, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, detach, payload, channel, context);
    }

    @Override
    public void handleEnd(int frameSize, End end, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, end, payload, channel, context);
    }

    @Override
    public void handleClose(int frameSize, Close close, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, close, payload, channel, context);
    }

    @Override
    public void handleHeartBeat(int frameSize, HeartBeat thump, ByteBuffer payload, int channel, AMQPTestDriver context) {
        this.doVerification(frameSize, thump, payload, channel, context);
    }

    @Override
    public void handleMechanisms(int frameSize, SaslMechanisms saslMechanisms, AMQPTestDriver context) {
        this.doVerification(frameSize, saslMechanisms, null, 0, context);
    }

    @Override
    public void handleInit(int frameSize, SaslInit saslInit, AMQPTestDriver context) {
        this.doVerification(frameSize, saslInit, null, 0, context);
    }

    @Override
    public void handleChallenge(int frameSize, SaslChallenge saslChallenge, AMQPTestDriver context) {
        this.doVerification(frameSize, saslChallenge, null, 0, context);
    }

    @Override
    public void handleResponse(int frameSize, SaslResponse saslResponse, AMQPTestDriver context) {
        this.doVerification(frameSize, saslResponse, null, 0, context);
    }

    @Override
    public void handleOutcome(int frameSize, SaslOutcome saslOutcome, AMQPTestDriver context) {
        this.doVerification(frameSize, saslOutcome, null, 0, context);
    }

    @Override
    public void handleAMQPHeader(AMQPHeader header, AMQPTestDriver context) {
        this.doVerification(header.getBuffer().length, header, null, 0, context);
    }

    @Override
    public void handleSASLHeader(AMQPHeader header, AMQPTestDriver context) {
        this.doVerification(header.getBuffer().length, header, null, 0, context);
    }

    private void doVerification(int frameSize, Object performative, ByteBuffer payload, int channel, AMQPTestDriver driver) {
        if (this.getExpectedTypeClass().equals(performative.getClass())) {
            this.verifyFrameSize(frameSize);
            this.verifyPayload(payload);
            this.verifyChannel(channel);
            this.verifyPerformative((ListDescribedType)this.getExpectedTypeClass().cast(performative));
            if (this.verificationPredicate != null) {
                try {
                    if (!this.verificationPredicate.test((ListDescribedType)performative)) {
                        throw new AssertionError((Object)"Failed to pass user supplied performative verification predicate");
                    }
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new AssertionError((Object)"Performative should not have been sent with a payload: ");
                }
            }
            if (this.performativeCapture != null) {
                try {
                    this.performativeCapture.accept((ListDescribedType)performative);
                }
                catch (Exception exception) {}
            }
        } else {
            this.reportTypeExpectationError(performative, this.getExpectedTypeClass());
        }
    }

    private void reportTypeExpectationError(Object received, Class<T> expected) {
        throw new UnexpectedPerformativeError((Object)("Expected type: " + String.valueOf(expected) + " but received value: " + String.valueOf(received)));
    }
}

