/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.AttachInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.DetachInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Source;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Target;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusDurability;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusExpiryPolicy;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transactions.Coordinator;
import org.apache.qpid.protonj2.test.driver.codec.transport.Attach;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;
import org.apache.qpid.protonj2.test.driver.codec.transport.SenderSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.JmsNoLocalByIdDescribedType;
import org.apache.qpid.protonj2.test.driver.matchers.JmsSelectorByIdDescribedType;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.SourceMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.TargetMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transactions.CoordinatorMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.AttachMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.ArrayMatching;

public class AttachExpectation
extends AbstractExpectation<Attach> {
    private final AttachMatcher matcher = new AttachMatcher();
    private AttachInjectAction response;
    private boolean rejecting;
    private boolean inKindResponse;

    public AttachExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withName(CoreMatchers.notNullValue());
        this.withHandle(CoreMatchers.notNullValue());
        this.withRole(CoreMatchers.notNullValue());
    }

    public AttachExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    public AttachExpectation optional() {
        return (AttachExpectation)super.optional();
    }

    public AttachExpectation withPredicate(Predicate<Attach> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public AttachExpectation withCapture(Consumer<Attach> capture) {
        super.withCapture(capture);
        return this;
    }

    public AttachInjectAction respond() {
        this.response = new AttachInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public AttachInjectAction respondInKind() {
        this.response = new AttachInjectAction(this.driver);
        this.inKindResponse = true;
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public DetachInjectAction reject(boolean close, String condition, String description) {
        return this.reject(close, Symbol.valueOf(condition), description);
    }

    public DetachInjectAction reject(boolean close, Symbol condition, String description) {
        this.rejecting = true;
        this.response = new AttachInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        DetachInjectAction action = new DetachInjectAction(this.driver).withClosed(close).withErrorCondition(condition, description);
        this.driver.addScriptedElement(action);
        return action;
    }

    @Override
    public void handleAttach(int frameSize, Attach attach, ByteBuffer payload, int channel, AMQPTestDriver context) {
        super.handleAttach(frameSize, attach, payload, channel, context);
        UnsignedShort remoteChannel = UnsignedShort.valueOf(channel);
        SessionTracker session = this.driver.sessions().getSessionFromRemoteChannel(remoteChannel);
        if (session == null) {
            throw new AssertionError((Object)String.format("Received Attach on channel [%s] that has no matching Session for that remote channel. ", remoteChannel));
        }
        LinkTracker link = session.handleRemoteAttach(attach);
        if (this.response != null) {
            Role role;
            if (this.response.onChannel() == -1) {
                this.response.onChannel(link.getSession().getLocalChannel());
            }
            if (this.response.getPerformative().getHandle() == null) {
                this.response.withHandle(session.findFreeLocalHandle());
            }
            if (this.response.getPerformative().getName() == null) {
                this.response.withName(attach.getName());
            }
            if (this.response.getPerformative().getRole() == null) {
                this.response.withRole(Boolean.TRUE.equals(attach.getRole()) ? Role.SENDER : Role.RECEIVER);
            }
            if (this.response.getPerformative().getSenderSettleMode() == null) {
                this.response.withSndSettleMode(SenderSettleMode.valueOf(attach.getSenderSettleMode()));
            }
            if (this.response.getPerformative().getReceiverSettleMode() == null) {
                this.response.withRcvSettleMode(ReceiverSettleMode.valueOf(attach.getReceiverSettleMode()));
            }
            if (this.response.getPerformative().getSource() == null && !this.response.isNullSourceRequired()) {
                this.response.withSource(attach.getSource());
                if (attach.getSource() != null && Boolean.TRUE.equals(attach.getSource().getDynamic())) {
                    attach.getSource().setAddress(UUID.randomUUID().toString());
                }
            }
            if (this.rejecting) {
                if (Boolean.FALSE.equals(attach.getRole())) {
                    this.response.withNullTarget();
                } else {
                    this.response.withNullSource();
                }
            }
            if (this.response.getPerformative().getTarget() == null && !this.response.isNullTargetRequired() && attach.getTarget() != null) {
                if (attach.getTarget() instanceof Target) {
                    Target target = (Target)attach.getTarget();
                    this.response.withTarget(target);
                    if (target != null && Boolean.TRUE.equals(target.getDynamic())) {
                        target.setAddress(UUID.randomUUID().toString());
                    }
                } else {
                    Coordinator coordinator = (Coordinator)attach.getTarget();
                    this.response.withTarget(coordinator);
                }
            }
            if (this.response.getPerformative().getInitialDeliveryCount() == null && !this.response.isExplicitlyNullDeliveryCount() && (role = Role.valueOf(this.response.getPerformative().getRole())) == Role.SENDER) {
                this.response.withInitialDeliveryCount(0L);
            }
            if (this.inKindResponse) {
                Symbol[] desired = attach.getDesiredCapabilities();
                if (desired != null && desired.length > 0) {
                    this.response.withOfferedCapabilities(Arrays.copyOf(desired, desired.length));
                }
                if (attach.getMaxMessageSize() != null) {
                    this.response.withMaxMessageSize(attach.getMaxMessageSize());
                }
            }
        }
    }

    public AttachExpectation withName(String name) {
        return this.withName(CoreMatchers.equalTo((Object)name));
    }

    public AttachExpectation withHandle(int handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public AttachExpectation withHandle(long handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public AttachExpectation withHandle(UnsignedInteger handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)handle));
    }

    public AttachExpectation withRole(boolean role) {
        return this.withRole(CoreMatchers.equalTo((Object)role));
    }

    public AttachExpectation withRole(Boolean role) {
        return this.withRole(CoreMatchers.equalTo((Object)role));
    }

    public AttachExpectation withRole(Role role) {
        return this.withRole(CoreMatchers.equalTo((Object)role.getValue()));
    }

    public AttachExpectation ofSender() {
        return this.withRole(CoreMatchers.equalTo((Object)Role.SENDER.getValue()));
    }

    public AttachExpectation ofReceiver() {
        return this.withRole(CoreMatchers.equalTo((Object)Role.RECEIVER.getValue()));
    }

    public AttachExpectation withSndSettleMode(byte sndSettleMode) {
        return this.withSndSettleMode(CoreMatchers.equalTo((Object)UnsignedByte.valueOf(sndSettleMode)));
    }

    public AttachExpectation withSndSettleMode(Byte sndSettleMode) {
        return this.withSndSettleMode(sndSettleMode == null ? CoreMatchers.nullValue() : CoreMatchers.equalTo((Object)UnsignedByte.valueOf(sndSettleMode)));
    }

    public AttachExpectation withSndSettleMode(SenderSettleMode sndSettleMode) {
        return this.withSndSettleMode(sndSettleMode == null ? CoreMatchers.nullValue() : CoreMatchers.equalTo((Object)sndSettleMode.getValue()));
    }

    public AttachExpectation withSenderSettleModeMixed() {
        return this.withSndSettleMode(CoreMatchers.equalTo((Object)SenderSettleMode.MIXED.getValue()));
    }

    public AttachExpectation withSenderSettleModeSettled() {
        return this.withSndSettleMode(CoreMatchers.equalTo((Object)SenderSettleMode.SETTLED.getValue()));
    }

    public AttachExpectation withSenderSettleModeUnsettled() {
        return this.withSndSettleMode(CoreMatchers.equalTo((Object)SenderSettleMode.UNSETTLED.getValue()));
    }

    public AttachExpectation withRcvSettleMode(byte rcvSettleMode) {
        return this.withRcvSettleMode(CoreMatchers.equalTo((Object)UnsignedByte.valueOf(rcvSettleMode)));
    }

    public AttachExpectation withRcvSettleMode(Byte rcvSettleMode) {
        return this.withRcvSettleMode(rcvSettleMode == null ? CoreMatchers.nullValue() : CoreMatchers.equalTo((Object)UnsignedByte.valueOf(rcvSettleMode)));
    }

    public AttachExpectation withRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        return this.withRcvSettleMode(rcvSettleMode == null ? CoreMatchers.nullValue() : CoreMatchers.equalTo((Object)rcvSettleMode.getValue()));
    }

    public AttachExpectation withReceiverSettlesFirst() {
        return this.withRcvSettleMode(CoreMatchers.equalTo((Object)ReceiverSettleMode.FIRST.getValue()));
    }

    public AttachExpectation withReceiverSettlesSecond() {
        return this.withRcvSettleMode(CoreMatchers.equalTo((Object)ReceiverSettleMode.SECOND.getValue()));
    }

    public AttachSourceMatcher withSource() {
        AttachSourceMatcher matcher = new AttachSourceMatcher(this);
        this.withSource((Matcher<?>)matcher);
        return matcher;
    }

    public AttachTargetMatcher withTarget() {
        AttachTargetMatcher matcher = new AttachTargetMatcher(this);
        this.withTarget((Matcher<?>)matcher);
        return matcher;
    }

    public AttachCoordinatorMatcher withCoordinator() {
        AttachCoordinatorMatcher matcher = new AttachCoordinatorMatcher(this);
        this.withCoordinator((Matcher<?>)matcher);
        return matcher;
    }

    public AttachExpectation withNullSource() {
        return this.withSource(CoreMatchers.nullValue());
    }

    public AttachExpectation withSource(Source source) {
        if (source != null) {
            SourceMatcher sourceMatcher = new SourceMatcher(source);
            return this.withSource((Matcher<?>)sourceMatcher);
        }
        return this.withSource(CoreMatchers.nullValue());
    }

    public AttachExpectation withNullTarget() {
        return this.withTarget(CoreMatchers.nullValue());
    }

    public AttachExpectation withTarget(Target target) {
        if (target != null) {
            TargetMatcher targetMatcher = new TargetMatcher(target);
            return this.withTarget((Matcher<?>)targetMatcher);
        }
        return this.withTarget(CoreMatchers.nullValue());
    }

    public AttachExpectation withCoordinator(Coordinator coordinator) {
        if (coordinator != null) {
            CoordinatorMatcher coordinatorMatcher = new CoordinatorMatcher();
            return this.withCoordinator((Matcher<?>)coordinatorMatcher);
        }
        return this.withCoordinator(CoreMatchers.nullValue());
    }

    public AttachExpectation withUnsettled(Map<Binary, DeliveryState> unsettled) {
        return this.withUnsettled(CoreMatchers.equalTo(unsettled));
    }

    public AttachExpectation withIncompleteUnsettled(boolean incomplete) {
        return this.withIncompleteUnsettled(CoreMatchers.equalTo((Object)incomplete));
    }

    public AttachExpectation withInitialDeliveryCount(int initialDeliveryCount) {
        return this.withInitialDeliveryCount(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(initialDeliveryCount)));
    }

    public AttachExpectation withInitialDeliveryCount(long initialDeliveryCount) {
        return this.withInitialDeliveryCount(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(initialDeliveryCount)));
    }

    public AttachExpectation withInitialDeliveryCount(UnsignedInteger initialDeliveryCount) {
        return this.withInitialDeliveryCount(CoreMatchers.equalTo((Object)initialDeliveryCount));
    }

    public AttachExpectation withMaxMessageSize(long maxMessageSize) {
        return this.withMaxMessageSize(CoreMatchers.equalTo((Object)UnsignedLong.valueOf(maxMessageSize)));
    }

    public AttachExpectation withMaxMessageSize(UnsignedLong maxMessageSize) {
        return this.withMaxMessageSize(CoreMatchers.equalTo((Object)maxMessageSize));
    }

    public AttachExpectation withOfferedCapabilities(Symbol ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)offeredCapabilities));
    }

    public AttachExpectation withOfferedCapabilities(String ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(offeredCapabilities)));
    }

    public AttachExpectation withOfferedCapability(Symbol offeredCapability) {
        return this.withOfferedCapabilities(ArrayMatching.hasItemInArray((Object)offeredCapability));
    }

    public AttachExpectation withOfferedCapability(String offeredCapability) {
        return this.withOfferedCapabilities(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(offeredCapability)));
    }

    public AttachExpectation withDesiredCapabilities(Symbol ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)desiredCapabilities));
    }

    public AttachExpectation withDesiredCapabilities(String ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(desiredCapabilities)));
    }

    public AttachExpectation withDesiredCapability(Symbol desiredCapability) {
        return this.withDesiredCapabilities(ArrayMatching.hasItemInArray((Object)desiredCapability));
    }

    public AttachExpectation withDesiredCapability(String desiredCapability) {
        return this.withDesiredCapabilities(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(desiredCapability)));
    }

    public AttachExpectation withPropertiesMap(Map<Symbol, Object> properties) {
        return this.withProperties(CoreMatchers.equalTo(properties));
    }

    public AttachExpectation withProperties(Map<String, Object> properties) {
        return this.withProperties(CoreMatchers.equalTo(TypeMapper.toSymbolKeyedMap(properties)));
    }

    public AttachExpectation withName(Matcher<?> m) {
        this.matcher.withName(m);
        return this;
    }

    public AttachExpectation withHandle(Matcher<?> m) {
        this.matcher.withHandle(m);
        return this;
    }

    public AttachExpectation withRole(Matcher<?> m) {
        this.matcher.withRole(m);
        return this;
    }

    public AttachExpectation withSndSettleMode(Matcher<?> m) {
        this.matcher.withSndSettleMode(m);
        return this;
    }

    public AttachExpectation withRcvSettleMode(Matcher<?> m) {
        this.matcher.withRcvSettleMode(m);
        return this;
    }

    public AttachExpectation withSource(Matcher<?> m) {
        this.matcher.withSource(m);
        return this;
    }

    public AttachExpectation withTarget(Matcher<?> m) {
        this.matcher.withTarget(m);
        return this;
    }

    public AttachExpectation withCoordinator(Matcher<?> m) {
        this.matcher.withCoordinator(m);
        return this;
    }

    public AttachExpectation withUnsettled(Matcher<?> m) {
        this.matcher.withUnsettled(m);
        return this;
    }

    public AttachExpectation withIncompleteUnsettled(Matcher<?> m) {
        this.matcher.withIncompleteUnsettled(m);
        return this;
    }

    public AttachExpectation withInitialDeliveryCount(Matcher<?> m) {
        this.matcher.withInitialDeliveryCount(m);
        return this;
    }

    public AttachExpectation withMaxMessageSize(Matcher<?> m) {
        this.matcher.withMaxMessageSize(m);
        return this;
    }

    public AttachExpectation withOfferedCapabilities(Matcher<?> m) {
        this.matcher.withOfferedCapabilities(m);
        return this;
    }

    public AttachExpectation withDesiredCapabilities(Matcher<?> m) {
        this.matcher.withDesiredCapabilities(m);
        return this;
    }

    public AttachExpectation withProperties(Matcher<?> m) {
        this.matcher.withProperties(m);
        return this;
    }

    public AttachExpectation withProperty(String key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    public AttachExpectation withProperty(Symbol key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<Attach> getExpectedTypeClass() {
        return Attach.class;
    }

    public static class AttachSourceMatcher
    extends SourceMatcher {
        private final AttachExpectation expectation;

        public AttachSourceMatcher(AttachExpectation expectation) {
            this.expectation = expectation;
        }

        public AttachExpectation also() {
            return this.expectation;
        }

        public AttachExpectation and() {
            return this.expectation;
        }

        @Override
        public AttachSourceMatcher withAddress(String name) {
            super.withAddress(name);
            return this;
        }

        @Override
        public AttachSourceMatcher withDurable(TerminusDurability durability) {
            super.withDurable(durability);
            return this;
        }

        @Override
        public AttachSourceMatcher withExpiryPolicy(TerminusExpiryPolicy expiry) {
            super.withExpiryPolicy(expiry);
            return this;
        }

        @Override
        public AttachSourceMatcher withTimeout(int timeout) {
            super.withTimeout(timeout);
            return this;
        }

        @Override
        public AttachSourceMatcher withTimeout(long timeout) {
            super.withTimeout(timeout);
            return this;
        }

        @Override
        public AttachSourceMatcher withTimeout(UnsignedInteger timeout) {
            super.withTimeout(timeout);
            return this;
        }

        @Override
        public AttachSourceMatcher withDynamic(boolean dynamic) {
            super.withDynamic(dynamic);
            return this;
        }

        @Override
        public AttachSourceMatcher withDynamicNodePropertiesMap(Map<Symbol, Object> properties) {
            super.withDynamicNodePropertiesMap(properties);
            return this;
        }

        @Override
        public AttachSourceMatcher withDynamicNodeProperties(Map<String, Object> properties) {
            super.withDynamicNodeProperties(properties);
            return this;
        }

        @Override
        public AttachSourceMatcher withDistributionMode(String distributionMode) {
            super.withDistributionMode(distributionMode);
            return this;
        }

        @Override
        public AttachSourceMatcher withDistributionMode(Symbol distributionMode) {
            super.withDistributionMode(distributionMode);
            return this;
        }

        @Override
        public AttachSourceMatcher withFilter(Map<String, Object> filter) {
            super.withFilter(filter);
            return this;
        }

        public AttachSourceMatcher withJMSSelector(String selector) {
            JmsSelectorByIdDescribedType filterType = new JmsSelectorByIdDescribedType(selector);
            HashMap<String, Object> filtersMap = new HashMap<String, Object>();
            filtersMap.put("jms-selector", filterType);
            super.withFilter(filtersMap);
            return this;
        }

        public AttachSourceMatcher withNoLocal() {
            JmsNoLocalByIdDescribedType filterType = new JmsNoLocalByIdDescribedType();
            HashMap<String, Object> filtersMap = new HashMap<String, Object>();
            filtersMap.put("no-local", filterType);
            super.withFilter(filtersMap);
            return this;
        }

        @Override
        public AttachSourceMatcher withDefaultOutcome(DeliveryState defaultOutcome) {
            super.withDefaultOutcome(defaultOutcome);
            return this;
        }

        @Override
        public AttachSourceMatcher withOutcomes(String ... outcomes) {
            super.withOutcomes(outcomes);
            return this;
        }

        @Override
        public AttachSourceMatcher withOutcomes(Symbol ... outcomes) {
            super.withOutcomes(outcomes);
            return this;
        }

        @Override
        public AttachSourceMatcher withCapabilities(String ... capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }

        @Override
        public AttachSourceMatcher withCapabilities(Symbol ... capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }

        @Override
        public AttachSourceMatcher withAddress(Matcher<?> m) {
            super.withAddress(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withDurable(Matcher<?> m) {
            super.withDurable(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withExpiryPolicy(Matcher<?> m) {
            super.withExpiryPolicy(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withTimeout(Matcher<?> m) {
            super.withTimeout(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withDefaultTimeout() {
            super.withTimeout((Matcher<?>)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.nullValue(), CoreMatchers.equalTo((Object)UnsignedInteger.ZERO)}));
            return this;
        }

        @Override
        public AttachSourceMatcher withDynamic(Matcher<?> m) {
            super.withDynamic(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withDynamicNodeProperties(Matcher<?> m) {
            super.withDynamicNodeProperties(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withDistributionMode(Matcher<?> m) {
            super.withDistributionMode(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withFilter(Matcher<?> m) {
            super.withFilter(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withDefaultOutcome(Matcher<?> m) {
            super.withDefaultOutcome(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withOutcomes(Matcher<?> m) {
            super.withOutcomes(m);
            return this;
        }

        @Override
        public AttachSourceMatcher withCapabilities(Matcher<?> m) {
            super.withCapabilities(m);
            return this;
        }
    }

    public static class AttachTargetMatcher
    extends TargetMatcher {
        private final AttachExpectation expectation;

        public AttachTargetMatcher(AttachExpectation expectation) {
            this.expectation = expectation;
        }

        public AttachExpectation also() {
            return this.expectation;
        }

        public AttachExpectation and() {
            return this.expectation;
        }

        @Override
        public AttachTargetMatcher withAddress(String name) {
            super.withAddress(name);
            return this;
        }

        @Override
        public AttachTargetMatcher withDurable(TerminusDurability durability) {
            super.withDurable(durability);
            return this;
        }

        @Override
        public AttachTargetMatcher withExpiryPolicy(TerminusExpiryPolicy expiry) {
            super.withExpiryPolicy(expiry);
            return this;
        }

        @Override
        public AttachTargetMatcher withTimeout(int timeout) {
            super.withTimeout(timeout);
            return this;
        }

        @Override
        public AttachTargetMatcher withTimeout(long timeout) {
            super.withTimeout(timeout);
            return this;
        }

        @Override
        public AttachTargetMatcher withTimeout(UnsignedInteger timeout) {
            super.withTimeout(timeout);
            return this;
        }

        @Override
        public AttachTargetMatcher withDefaultTimeout() {
            super.withDefaultTimeout();
            return this;
        }

        @Override
        public AttachTargetMatcher withDynamic(boolean dynamic) {
            super.withDynamic(dynamic);
            return this;
        }

        @Override
        public AttachTargetMatcher withDynamicNodeProperties(Map<String, Object> properties) {
            super.withDynamicNodeProperties(properties);
            return this;
        }

        @Override
        public AttachTargetMatcher withCapabilities(Symbol ... capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }

        @Override
        public AttachTargetMatcher withCapabilities(String ... capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }

        @Override
        public AttachTargetMatcher withAddress(Matcher<?> m) {
            super.withAddress(m);
            return this;
        }

        @Override
        public AttachTargetMatcher withDurable(Matcher<?> m) {
            super.withDurable(m);
            return this;
        }

        @Override
        public AttachTargetMatcher withExpiryPolicy(Matcher<?> m) {
            super.withExpiryPolicy(m);
            return this;
        }

        @Override
        public AttachTargetMatcher withTimeout(Matcher<?> m) {
            super.withTimeout(m);
            return this;
        }

        @Override
        public AttachTargetMatcher withDynamic(Matcher<?> m) {
            super.withDynamic(m);
            return this;
        }

        @Override
        public AttachTargetMatcher withDynamicNodeProperties(Matcher<?> m) {
            super.withDynamicNodeProperties(m);
            return this;
        }

        @Override
        public AttachTargetMatcher withCapabilities(Matcher<?> m) {
            super.withCapabilities(m);
            return this;
        }
    }

    public static class AttachCoordinatorMatcher
    extends CoordinatorMatcher {
        private final AttachExpectation expectation;

        public AttachCoordinatorMatcher(AttachExpectation expectation) {
            this.expectation = expectation;
        }

        public AttachExpectation also() {
            return this.expectation;
        }

        public AttachExpectation and() {
            return this.expectation;
        }

        @Override
        public AttachCoordinatorMatcher withCapabilities(Symbol ... capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }

        @Override
        public AttachCoordinatorMatcher withCapabilities(String ... capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }
    }
}

