/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.actions.BeginInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.EndInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Begin;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.transport.BeginMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.ArrayMatching;

public class BeginExpectation
extends AbstractExpectation<Begin> {
    private final BeginMatcher matcher = new BeginMatcher();
    private BeginInjectAction response;

    public BeginExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withRemoteChannel((Matcher<?>)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.nullValue(), CoreMatchers.notNullValue()}));
        this.withNextOutgoingId(CoreMatchers.notNullValue());
        this.withIncomingWindow(CoreMatchers.notNullValue());
        this.withOutgoingWindow(CoreMatchers.notNullValue());
    }

    public BeginExpectation withPredicate(Predicate<Begin> predicate) {
        this.withPredicate((Predicate)predicate);
        return this;
    }

    public BeginExpectation withCapture(Consumer<Begin> capture) {
        this.withCapture((Consumer)capture);
        return this;
    }

    public BeginExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    public BeginExpectation optional() {
        super.optional();
        return this;
    }

    public BeginInjectAction respond() {
        this.response = new BeginInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public EndInjectAction reject(String condition, String description) {
        return this.reject(Symbol.valueOf(condition), description);
    }

    public EndInjectAction reject(Symbol condition, String description) {
        this.response = new BeginInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        EndInjectAction endAction = new EndInjectAction(this.driver).withErrorCondition(condition, description);
        this.driver.addScriptedElement(endAction);
        return endAction;
    }

    @Override
    public void handleBegin(int frameSize, Begin begin, ByteBuffer payload, int channel, AMQPTestDriver context) {
        super.handleBegin(frameSize, begin, payload, channel, context);
        context.sessions().handleBegin(begin, UnsignedShort.valueOf(channel));
        if (this.response != null) {
            this.response.withRemoteChannel(channel);
        }
    }

    public BeginExpectation withRemoteChannel(int remoteChannel) {
        return this.withRemoteChannel(CoreMatchers.equalTo((Object)UnsignedShort.valueOf((short)remoteChannel)));
    }

    public BeginExpectation withRemoteChannel(UnsignedShort remoteChannel) {
        return this.withRemoteChannel(CoreMatchers.equalTo((Object)remoteChannel));
    }

    public BeginExpectation withNextOutgoingId(int nextOutgoingId) {
        return this.withNextOutgoingId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(nextOutgoingId)));
    }

    public BeginExpectation withNextOutgoingId(long nextOutgoingId) {
        return this.withNextOutgoingId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(nextOutgoingId)));
    }

    public BeginExpectation withNextOutgoingId(UnsignedInteger nextOutgoingId) {
        return this.withNextOutgoingId(CoreMatchers.equalTo((Object)nextOutgoingId));
    }

    public BeginExpectation withIncomingWindow(int incomingWindow) {
        return this.withIncomingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(incomingWindow)));
    }

    public BeginExpectation withIncomingWindow(long incomingWindow) {
        return this.withIncomingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(incomingWindow)));
    }

    public BeginExpectation withIncomingWindow(UnsignedInteger incomingWindow) {
        return this.withIncomingWindow(CoreMatchers.equalTo((Object)incomingWindow));
    }

    public BeginExpectation withOutgoingWindow(int outgoingWindow) {
        return this.withOutgoingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(outgoingWindow)));
    }

    public BeginExpectation withOutgoingWindow(long outgoingWindow) {
        return this.withOutgoingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(outgoingWindow)));
    }

    public BeginExpectation withOutgoingWindow(UnsignedInteger outgoingWindow) {
        return this.withOutgoingWindow(CoreMatchers.equalTo((Object)outgoingWindow));
    }

    public BeginExpectation withHandleMax(int handleMax) {
        return this.withHandleMax(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handleMax)));
    }

    public BeginExpectation withHandleMax(long handleMax) {
        return this.withHandleMax(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handleMax)));
    }

    public BeginExpectation withHandleMax(UnsignedInteger handleMax) {
        return this.withHandleMax(CoreMatchers.equalTo((Object)handleMax));
    }

    public BeginExpectation withOfferedCapabilities(String ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(offeredCapabilities)));
    }

    public BeginExpectation withOfferedCapabilities(Symbol ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)offeredCapabilities));
    }

    public BeginExpectation withOfferedCapability(Symbol offeredCapability) {
        return this.withOfferedCapabilities(ArrayMatching.hasItemInArray((Object)offeredCapability));
    }

    public BeginExpectation withOfferedCapability(String offeredCapability) {
        return this.withOfferedCapabilities(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(offeredCapability)));
    }

    public BeginExpectation withDesiredCapabilities(String ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(desiredCapabilities)));
    }

    public BeginExpectation withDesiredCapabilities(Symbol ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)desiredCapabilities));
    }

    public BeginExpectation withDesiredCapability(Symbol desiredCapability) {
        return this.withDesiredCapabilities(ArrayMatching.hasItemInArray((Object)desiredCapability));
    }

    public BeginExpectation withDesiredCapability(String desiredCapability) {
        return this.withDesiredCapabilities(ArrayMatching.hasItemInArray((Object)Symbol.valueOf(desiredCapability)));
    }

    public BeginExpectation withPropertiesMap(Map<Symbol, Object> properties) {
        return this.withProperties(CoreMatchers.equalTo(properties));
    }

    public BeginExpectation withProperties(Map<String, Object> properties) {
        return this.withProperties(CoreMatchers.equalTo(TypeMapper.toSymbolKeyedMap(properties)));
    }

    public BeginExpectation withRemoteChannel(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.REMOTE_CHANNEL, m);
        return this;
    }

    public BeginExpectation withNextOutgoingId(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.NEXT_OUTGOING_ID, m);
        return this;
    }

    public BeginExpectation withIncomingWindow(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.INCOMING_WINDOW, m);
        return this;
    }

    public BeginExpectation withOutgoingWindow(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.OUTGOING_WINDOW, m);
        return this;
    }

    public BeginExpectation withHandleMax(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.HANDLE_MAX, m);
        return this;
    }

    public BeginExpectation withOfferedCapabilities(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.OFFERED_CAPABILITIES, m);
        return this;
    }

    public BeginExpectation withDesiredCapabilities(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.DESIRED_CAPABILITIES, m);
        return this;
    }

    public BeginExpectation withProperties(Matcher<?> m) {
        this.matcher.addFieldMatcher(Begin.Field.PROPERTIES, m);
        return this;
    }

    public BeginExpectation withProperty(String key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    public BeginExpectation withProperty(Symbol key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<Begin> getExpectedTypeClass() {
        return Begin.class;
    }
}

