/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.EndInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.End;
import org.apache.qpid.protonj2.test.driver.codec.transport.ErrorCondition;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.transport.EndMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.ErrorConditionMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class EndExpectation
extends AbstractExpectation<End> {
    private final EndMatcher matcher = new EndMatcher();
    private EndInjectAction response;

    public EndExpectation(AMQPTestDriver driver) {
        super(driver);
    }

    public EndExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    public EndExpectation optional() {
        return (EndExpectation)super.optional();
    }

    public EndInjectAction respond() {
        this.response = new EndInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public EndExpectation withPredicate(Predicate<End> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public EndExpectation withCapture(Consumer<End> capture) {
        super.withCapture(capture);
        return this;
    }

    @Override
    public void handleEnd(int frameSize, End end, ByteBuffer payload, int channel, AMQPTestDriver context) {
        super.handleEnd(frameSize, end, payload, channel, context);
        SessionTracker session = context.sessions().handleEnd(end, UnsignedShort.valueOf(channel));
        if (this.response != null && this.response.onChannel() == -1) {
            this.response.onChannel(session.getLocalChannel());
        }
    }

    public EndExpectation withError(ErrorCondition error) {
        return this.withError(CoreMatchers.equalTo((Object)error));
    }

    public EndExpectation withError(String condition, String description) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(Symbol.valueOf(condition), description)));
    }

    public EndExpectation withError(String condition, String description, Map<String, Object> info) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info))));
    }

    public EndExpectation withError(Symbol condition, String description) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(condition, description)));
    }

    public EndExpectation withError(Symbol condition, String description, Map<Symbol, Object> info) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(condition, description, info)));
    }

    public EndExpectation withError(String condition) {
        return this.withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition));
    }

    public EndExpectation withError(String condition, Matcher<?> descriptionMatcher) {
        return this.withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(descriptionMatcher));
    }

    public EndExpectation withError(String condition, Matcher<?> descriptionMatcher, Matcher<?> infoMapMatcher) {
        return this.withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(descriptionMatcher).withInfo(infoMapMatcher));
    }

    public EndExpectation withError(Matcher<?> m) {
        this.matcher.addFieldMatcher(End.Field.ERROR, m);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<End> getExpectedTypeClass() {
        return End.class;
    }
}

