/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.FlowInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Flow;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.transport.FlowMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class FlowExpectation
extends AbstractExpectation<Flow> {
    private final FlowMatcher matcher = new FlowMatcher();
    private FlowInjectAction response;

    public FlowExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withNextIncomingId((Matcher<?>)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.nullValue(), CoreMatchers.notNullValue()}));
        this.withIncomingWindow(CoreMatchers.notNullValue());
        this.withNextOutgoingId(CoreMatchers.notNullValue());
        this.withOutgoingWindow(CoreMatchers.notNullValue());
    }

    public FlowExpectation optional() {
        return (FlowExpectation)super.optional();
    }

    public FlowExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    public FlowInjectAction respond() {
        this.response = new FlowInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public FlowExpectation withPredicate(Predicate<Flow> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public FlowExpectation withCapture(Consumer<Flow> capture) {
        super.withCapture(capture);
        return this;
    }

    @Override
    public void handleFlow(int frameSize, Flow flow, ByteBuffer payload, int channel, AMQPTestDriver context) {
        super.handleFlow(frameSize, flow, payload, channel, context);
        UnsignedShort remoteChannel = UnsignedShort.valueOf(channel);
        SessionTracker session = this.driver.sessions().getSessionFromRemoteChannel(remoteChannel);
        if (session == null) {
            throw new AssertionError((Object)String.format("Received Flow on channel [%s] that has no matching Session for that remote channel. ", remoteChannel));
        }
        LinkTracker linkTracker = session.handleFlow(flow);
        if (this.response != null) {
            if (this.response.onChannel() == -1) {
                this.response.onChannel(session.getLocalChannel());
            }
            if (this.response.getPerformative().getNextIncomingId() == null) {
                this.response.withNextIncomingId(flow.getNextOutgoingId().longValue());
            }
            if (this.response.getPerformative().getIncomingWindow() == null) {
                this.response.withIncomingWindow(Integer.MAX_VALUE);
            }
            if (this.response.getPerformative().getNextOutgoingId() == null) {
                this.response.withNextOutgoingId(flow.getNextIncomingId().longValue());
            }
            if (this.response.getPerformative().getOutgoingWindow() == null) {
                this.response.withOutgoingWindow(0L);
            }
            if (this.response.getPerformative().getHandle() == null && linkTracker != null) {
                this.response.withHandle(linkTracker.getHandle());
            }
        }
    }

    public FlowExpectation withNextIncomingId(int nextIncomingId) {
        return this.withNextIncomingId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(nextIncomingId)));
    }

    public FlowExpectation withNextIncomingId(long nextIncomingId) {
        return this.withNextIncomingId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(nextIncomingId)));
    }

    public FlowExpectation withNextIncomingId(UnsignedInteger nextIncomingId) {
        return this.withNextIncomingId(CoreMatchers.equalTo((Object)nextIncomingId));
    }

    public FlowExpectation withIncomingWindow(int incomingWindow) {
        return this.withIncomingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(incomingWindow)));
    }

    public FlowExpectation withIncomingWindow(long incomingWindow) {
        return this.withIncomingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(incomingWindow)));
    }

    public FlowExpectation withIncomingWindow(UnsignedInteger incomingWindow) {
        return this.withIncomingWindow(CoreMatchers.equalTo((Object)incomingWindow));
    }

    public FlowExpectation withNextOutgoingId(int nextOutgoingId) {
        return this.withNextOutgoingId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(nextOutgoingId)));
    }

    public FlowExpectation withNextOutgoingId(long nextOutgoingId) {
        return this.withNextOutgoingId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(nextOutgoingId)));
    }

    public FlowExpectation withNextOutgoingId(UnsignedInteger nextOutgoingId) {
        return this.withNextOutgoingId(CoreMatchers.equalTo((Object)nextOutgoingId));
    }

    public FlowExpectation withOutgoingWindow(int outgoingWindow) {
        return this.withOutgoingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(outgoingWindow)));
    }

    public FlowExpectation withOutgoingWindow(long outgoingWindow) {
        return this.withOutgoingWindow(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(outgoingWindow)));
    }

    public FlowExpectation withOutgoingWindow(UnsignedInteger outgoingWindow) {
        return this.withOutgoingWindow(CoreMatchers.equalTo((Object)outgoingWindow));
    }

    public FlowExpectation withHandle(int handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public FlowExpectation withHandle(long handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public FlowExpectation withHandle(UnsignedInteger handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)handle));
    }

    public FlowExpectation withDeliveryCount(int deliveryCount) {
        return this.withDeliveryCount(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryCount)));
    }

    public FlowExpectation withDeliveryCount(long deliveryCount) {
        return this.withDeliveryCount(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryCount)));
    }

    public FlowExpectation withDeliveryCount(UnsignedInteger deliveryCount) {
        return this.withDeliveryCount(CoreMatchers.equalTo((Object)deliveryCount));
    }

    public FlowExpectation withLinkCredit(int linkCredit) {
        return this.withLinkCredit(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(linkCredit)));
    }

    public FlowExpectation withLinkCredit(long linkCredit) {
        return this.withLinkCredit(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(linkCredit)));
    }

    public FlowExpectation withLinkCredit(UnsignedInteger linkCredit) {
        return this.withLinkCredit(CoreMatchers.equalTo((Object)linkCredit));
    }

    public FlowExpectation withAvailable(int available) {
        return this.withAvailable(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(available)));
    }

    public FlowExpectation withAvailable(long available) {
        return this.withAvailable(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(available)));
    }

    public FlowExpectation withAvailable(UnsignedInteger available) {
        return this.withAvailable(CoreMatchers.equalTo((Object)available));
    }

    public FlowExpectation withDrain(boolean drain) {
        return this.withDrain(CoreMatchers.equalTo((Object)drain));
    }

    public FlowExpectation withEcho(boolean echo) {
        return this.withEcho(CoreMatchers.equalTo((Object)echo));
    }

    public FlowExpectation withProperties(Map<Symbol, Object> properties) {
        return this.withProperties(CoreMatchers.equalTo(properties));
    }

    public FlowExpectation withNextIncomingId(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.NEXT_INCOMING_ID, m);
        return this;
    }

    public FlowExpectation withIncomingWindow(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.INCOMING_WINDOW, m);
        return this;
    }

    public FlowExpectation withNextOutgoingId(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.NEXT_OUTGOING_ID, m);
        return this;
    }

    public FlowExpectation withOutgoingWindow(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.OUTGOING_WINDOW, m);
        return this;
    }

    public FlowExpectation withHandle(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.HANDLE, m);
        return this;
    }

    public FlowExpectation withDeliveryCount(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.DELIVERY_COUNT, m);
        return this;
    }

    public FlowExpectation withLinkCredit(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.LINK_CREDIT, m);
        return this;
    }

    public FlowExpectation withAvailable(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.AVAILABLE, m);
        return this;
    }

    public FlowExpectation withDrain(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.DRAIN, m);
        return this;
    }

    public FlowExpectation withEcho(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.ECHO, m);
        return this;
    }

    public FlowExpectation withProperties(Matcher<?> m) {
        this.matcher.addFieldMatcher(Flow.Field.PROPERTIES, m);
        return this;
    }

    public FlowExpectation withProperty(String key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    public FlowExpectation withProperty(Symbol key, Object value) {
        this.matcher.withProperty(key, value);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<Flow> getExpectedTypeClass() {
        return Flow.class;
    }
}

