/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.actions.SaslResponseInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslChallenge;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.security.SaslChallengeMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class SaslChallengeExpectation
extends AbstractExpectation<SaslChallenge> {
    private final SaslChallengeMatcher matcher = new SaslChallengeMatcher();

    public SaslChallengeExpectation(AMQPTestDriver driver) {
        super(driver);
    }

    public SaslChallengeExpectation withPredicate(Predicate<SaslChallenge> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public SaslChallengeExpectation withCapture(Consumer<SaslChallenge> capture) {
        super.withCapture(capture);
        return this;
    }

    public SaslResponseInjectAction respond() {
        SaslResponseInjectAction response = new SaslResponseInjectAction(this.driver);
        this.driver.addScriptedElement(response);
        return response;
    }

    public SaslChallengeExpectation withChallenge(byte[] challenge) {
        return this.withChallenge(CoreMatchers.equalTo((Object)new Binary(challenge)));
    }

    public SaslChallengeExpectation withChallenge(Binary challenge) {
        return this.withChallenge(CoreMatchers.equalTo((Object)challenge));
    }

    public SaslChallengeExpectation withChallenge(Matcher<?> m) {
        this.matcher.addFieldMatcher(SaslChallenge.Field.CHALLENGE, m);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<SaslChallenge> getExpectedTypeClass() {
        return SaslChallenge.class;
    }
}

