/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.messaging;

import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Target;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusDurability;
import org.apache.qpid.protonj2.test.driver.codec.messaging.TerminusExpiryPolicy;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.matchers.ListDescribedTypeMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class TargetMatcher
extends ListDescribedTypeMatcher {
    public TargetMatcher() {
        super(Target.Field.values().length, Target.DESCRIPTOR_CODE, Target.DESCRIPTOR_SYMBOL);
    }

    public TargetMatcher(Target target) {
        super(Target.Field.values().length, Target.DESCRIPTOR_CODE, Target.DESCRIPTOR_SYMBOL);
        this.addTargetMatchers(target);
    }

    @Override
    protected Class<?> getDescribedTypeClass() {
        return Target.class;
    }

    public TargetMatcher withAddress(String name) {
        return this.withAddress(CoreMatchers.equalTo((Object)name));
    }

    public TargetMatcher withDurable(TerminusDurability durability) {
        return this.withDurable(CoreMatchers.equalTo((Object)durability.getValue()));
    }

    public TargetMatcher withExpiryPolicy(TerminusExpiryPolicy expiry) {
        return this.withExpiryPolicy(CoreMatchers.equalTo((Object)expiry.getPolicy()));
    }

    public TargetMatcher withTimeout(int timeout) {
        return this.withTimeout(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(timeout)));
    }

    public TargetMatcher withTimeout(long timeout) {
        return this.withTimeout(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(timeout)));
    }

    public TargetMatcher withTimeout(UnsignedInteger timeout) {
        return this.withTimeout(CoreMatchers.equalTo((Object)timeout));
    }

    public TargetMatcher withDefaultTimeout() {
        return this.withTimeout((Matcher<?>)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.nullValue(), CoreMatchers.equalTo((Object)UnsignedInteger.ZERO)}));
    }

    public TargetMatcher withDynamic(boolean dynamic) {
        return this.withDynamic(CoreMatchers.equalTo((Object)dynamic));
    }

    public TargetMatcher withDynamicNodeProperties(Map<String, Object> properties) {
        return this.withDynamicNodeProperties(CoreMatchers.equalTo(TypeMapper.toSymbolKeyedMap(properties)));
    }

    public TargetMatcher withDynamicNodePropertiesMap(Map<Symbol, Object> properties) {
        return this.withDynamicNodeProperties(CoreMatchers.equalTo(properties));
    }

    public TargetMatcher withCapabilities(String ... capabilities) {
        return this.withCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(capabilities)));
    }

    public TargetMatcher withCapabilities(Symbol ... capabilities) {
        return this.withCapabilities(CoreMatchers.equalTo((Object)capabilities));
    }

    public TargetMatcher withAddress(Matcher<?> m) {
        this.addFieldMatcher(Target.Field.ADDRESS, m);
        return this;
    }

    public TargetMatcher withDurable(Matcher<?> m) {
        this.addFieldMatcher(Target.Field.DURABLE, m);
        return this;
    }

    public TargetMatcher withExpiryPolicy(Matcher<?> m) {
        this.addFieldMatcher(Target.Field.EXPIRY_POLICY, m);
        return this;
    }

    public TargetMatcher withTimeout(Matcher<?> m) {
        this.addFieldMatcher(Target.Field.TIMEOUT, m);
        return this;
    }

    public TargetMatcher withDynamic(Matcher<?> m) {
        this.addFieldMatcher(Target.Field.DYNAMIC, m);
        return this;
    }

    public TargetMatcher withDynamicNodeProperties(Matcher<?> m) {
        this.addFieldMatcher(Target.Field.DYNAMIC_NODE_PROPERTIES, m);
        return this;
    }

    public TargetMatcher withCapabilities(Matcher<?> m) {
        this.addFieldMatcher(Target.Field.CAPABILITIES, m);
        return this;
    }

    private void addTargetMatchers(Target target) {
        if (target.getAddress() != null) {
            this.addFieldMatcher(Target.Field.ADDRESS, CoreMatchers.equalTo((Object)target.getAddress()));
        } else {
            this.addFieldMatcher(Target.Field.ADDRESS, CoreMatchers.nullValue());
        }
        if (target.getDurable() != null) {
            this.addFieldMatcher(Target.Field.DURABLE, CoreMatchers.equalTo((Object)target.getDurable()));
        } else {
            this.addFieldMatcher(Target.Field.DURABLE, CoreMatchers.nullValue());
        }
        if (target.getExpiryPolicy() != null) {
            this.addFieldMatcher(Target.Field.EXPIRY_POLICY, CoreMatchers.equalTo((Object)target.getExpiryPolicy()));
        } else {
            this.addFieldMatcher(Target.Field.EXPIRY_POLICY, CoreMatchers.nullValue());
        }
        if (target.getTimeout() != null) {
            this.addFieldMatcher(Target.Field.TIMEOUT, CoreMatchers.equalTo((Object)target.getTimeout()));
        } else {
            this.addFieldMatcher(Target.Field.TIMEOUT, CoreMatchers.nullValue());
        }
        this.addFieldMatcher(Target.Field.DYNAMIC, CoreMatchers.equalTo((Object)target.getDynamic()));
        if (target.getDynamicNodeProperties() != null) {
            this.addFieldMatcher(Target.Field.DYNAMIC_NODE_PROPERTIES, CoreMatchers.equalTo(target.getDynamicNodeProperties()));
        } else {
            this.addFieldMatcher(Target.Field.DYNAMIC_NODE_PROPERTIES, CoreMatchers.nullValue());
        }
        if (target.getCapabilities() != null) {
            this.addFieldMatcher(Target.Field.CAPABILITIES, CoreMatchers.equalTo((Object)target.getCapabilities()));
        } else {
            this.addFieldMatcher(Target.Field.CAPABILITIES, CoreMatchers.nullValue());
        }
    }
}

