/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.transport;

import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.transport.Transfer;
import org.apache.qpid.protonj2.test.driver.matchers.ListDescribedTypeMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class TransferMatcher
extends ListDescribedTypeMatcher {
    public TransferMatcher() {
        super(Transfer.Field.values().length, Transfer.DESCRIPTOR_CODE, Transfer.DESCRIPTOR_SYMBOL);
    }

    @Override
    protected Class<?> getDescribedTypeClass() {
        return Transfer.class;
    }

    public TransferMatcher withHandle(int handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public TransferMatcher withHandle(long handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public TransferMatcher withHandle(UnsignedInteger handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)handle));
    }

    public TransferMatcher withDeliveryId(int deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryId)));
    }

    public TransferMatcher withDeliveryId(long deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryId)));
    }

    public TransferMatcher withDeliveryId(UnsignedInteger deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)deliveryId));
    }

    public TransferMatcher withDeliveryTag(byte[] tag) {
        return this.withDeliveryTag(new Binary(tag));
    }

    public TransferMatcher withDeliveryTag(Binary deliveryTag) {
        return this.withDeliveryTag(CoreMatchers.equalTo((Object)deliveryTag));
    }

    public TransferMatcher withMessageFormat(int messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(messageFormat)));
    }

    public TransferMatcher withMessageFormat(long messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(messageFormat)));
    }

    public TransferMatcher withMessageFormat(UnsignedInteger messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)messageFormat));
    }

    public TransferMatcher withSettled(boolean settled) {
        return this.withSettled(CoreMatchers.equalTo((Object)settled));
    }

    public TransferMatcher withMore(boolean more) {
        return this.withMore(CoreMatchers.equalTo((Object)more));
    }

    public TransferMatcher withRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        return this.withRcvSettleMode(CoreMatchers.equalTo((Object)rcvSettleMode.getValue()));
    }

    public TransferMatcher withState(DeliveryState state) {
        return this.withState(CoreMatchers.equalTo((Object)state));
    }

    public TransferMatcher withNullState() {
        return this.withState(CoreMatchers.nullValue());
    }

    public TransferMatcher withResume(boolean resume) {
        return this.withResume(CoreMatchers.equalTo((Object)resume));
    }

    public TransferMatcher withAborted(boolean aborted) {
        return this.withAborted(CoreMatchers.equalTo((Object)aborted));
    }

    public TransferMatcher withBatchable(boolean batchable) {
        return this.withBatchable(CoreMatchers.equalTo((Object)batchable));
    }

    public TransferMatcher withHandle(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.HANDLE, m);
        return this;
    }

    public TransferMatcher withDeliveryId(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.DELIVERY_ID, m);
        return this;
    }

    public TransferMatcher withDeliveryTag(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.DELIVERY_TAG, m);
        return this;
    }

    public TransferMatcher withMessageFormat(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.MESSAGE_FORMAT, m);
        return this;
    }

    public TransferMatcher withSettled(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.SETTLED, m);
        return this;
    }

    public TransferMatcher withMore(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.MORE, m);
        return this;
    }

    public TransferMatcher withRcvSettleMode(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.RCV_SETTLE_MODE, m);
        return this;
    }

    public TransferMatcher withState(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.STATE, m);
        return this;
    }

    public TransferMatcher withResume(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.RESUME, m);
        return this;
    }

    public TransferMatcher withAborted(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.ABORTED, m);
        return this;
    }

    public TransferMatcher withBatchable(Matcher<?> m) {
        this.addFieldMatcher(Transfer.Field.BATCHABLE, m);
        return this;
    }
}

