/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.types;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedBodySectionMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class EncodedAmqpTypeMatcher
extends EncodedBodySectionMatcher {
    private final Symbol descriptorSymbol;
    private final UnsignedLong descriptorCode;
    private final Object expectedValue;
    private boolean allowTrailingBytes;
    private DescribedType decodedDescribedType;
    private boolean unexpectedTrailingBytes;

    public EncodedAmqpTypeMatcher(Symbol symbol, UnsignedLong code, Object expectedValue) {
        this(symbol, code, expectedValue, false);
    }

    public EncodedAmqpTypeMatcher(Symbol symbol, UnsignedLong code, Object expectedValue, boolean allowTrailingBytes) {
        this.descriptorSymbol = symbol;
        this.descriptorCode = code;
        this.expectedValue = expectedValue;
        this.allowTrailingBytes = allowTrailingBytes;
    }

    @Override
    public void setAllowTrailingBytes(boolean allowTrailingBytes) {
        this.allowTrailingBytes = allowTrailingBytes;
    }

    @Override
    public boolean isAllowTrailngBytes() {
        return this.allowTrailingBytes;
    }

    protected Object getExpectedValue() {
        return this.expectedValue;
    }

    protected boolean matchesSafely(ByteBuffer receivedBinary) {
        int length = receivedBinary.remaining();
        Codec data = Codec.Factory.create();
        long decoded = data.decode(receivedBinary);
        this.decodedDescribedType = data.getDescribedType();
        Object descriptor = this.decodedDescribedType.getDescriptor();
        if (!this.descriptorCode.equals(descriptor) && !this.descriptorSymbol.equals(descriptor)) {
            return false;
        }
        if (this.expectedValue == null && this.decodedDescribedType.getDescribed() != null) {
            return false;
        }
        if (this.expectedValue != null) {
            if (this.expectedValue instanceof Matcher) {
                Matcher matcher = (Matcher)this.expectedValue;
                if (!matcher.matches(this.decodedDescribedType.getDescribed())) {
                    return false;
                }
            } else if (this.expectedValue instanceof Map) {
                Map expectedMap = (Map)this.expectedValue;
                if (!(this.decodedDescribedType.getDescribed() instanceof Map)) {
                    return false;
                }
                Map receivedMap = (Map)this.decodedDescribedType.getDescribed();
                Matcher everyItemMatcher = Matchers.everyItem((Matcher)Matchers.is((Matcher)Matchers.in(expectedMap.entrySet())));
                Matcher containsInAnyOrder = Matchers.arrayContainingInAnyOrder((Object[])expectedMap.entrySet().toArray());
                if (receivedMap.size() != expectedMap.size()) {
                    return false;
                }
                if (!everyItemMatcher.matches(receivedMap.entrySet())) {
                    return false;
                }
                if (!containsInAnyOrder.matches((Object)receivedMap.entrySet().toArray())) {
                    return false;
                }
            } else {
                Matcher expectedValueMatcher = Matchers.is((Object)this.expectedValue);
                if (!expectedValueMatcher.matches(this.decodedDescribedType.getDescribed())) {
                    return false;
                }
            }
        }
        if (decoded < (long)length && !this.allowTrailingBytes) {
            this.unexpectedTrailingBytes = true;
            return false;
        }
        return true;
    }

    protected void describeMismatchSafely(ByteBuffer item, Description mismatchDescription) {
        mismatchDescription.appendText("\nActual encoded form: ").appendValue((Object)item);
        if (this.decodedDescribedType != null) {
            mismatchDescription.appendText("\nExpected descriptor: ").appendValue((Object)this.descriptorSymbol).appendText(" / ").appendValue((Object)this.descriptorCode);
            mismatchDescription.appendText("\nActual described type: ").appendValue((Object)this.decodedDescribedType);
        }
        if (this.unexpectedTrailingBytes) {
            mismatchDescription.appendText("\nUnexpected trailing bytes in provided bytes after decoding!");
        }
    }

    public abstract void describeTo(Description var1);
}

