/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.netty.netty4;

import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.qpid.protonj2.test.driver.ProtonTestClientOptions;
import org.apache.qpid.protonj2.test.driver.ProtonTestServerOptions;
import org.apache.qpid.protonj2.test.driver.netty.X509AliasKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static SslHandler createClientSslHandler(URI remote, ProtonTestClientOptions options) throws Exception {
        SSLContext sslContext = options.getSslContextOverride();
        if (sslContext == null) {
            sslContext = SslSupport.createClientJdkSslContext(options);
        }
        SSLEngine sslEngine = SslSupport.createClientJdkSslEngine(remote, sslContext, options);
        return new SslHandler(sslEngine);
    }

    public static SslHandler createServerSslHandler(URI remote, ProtonTestServerOptions options) throws Exception {
        SSLContext sslContext = options.getSslContextOverride();
        if (sslContext == null) {
            sslContext = SslSupport.createServerJdkSslContext(options);
        }
        SSLEngine sslEngine = SslSupport.createServerJdkSslEngine(remote, sslContext, options);
        return new SslHandler(sslEngine);
    }

    public static SSLContext createClientJdkSslContext(ProtonTestClientOptions options) throws Exception {
        try {
            String contextProtocol = options.getContextProtocol();
            LOG.trace("Getting SSLContext instance using protocol: {}", (Object)contextProtocol);
            SSLContext context = SSLContext.getInstance(contextProtocol);
            KeyManager[] keyMgrs = SslSupport.loadKeyManagers(options);
            TrustManager[] trustManagers = SslSupport.loadTrustManagers(options);
            context.init(keyMgrs, trustManagers, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            LOG.error("Failed to create SSLContext: {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static SSLContext createServerJdkSslContext(ProtonTestServerOptions options) throws Exception {
        try {
            String contextProtocol = options.getContextProtocol();
            LOG.trace("Getting SSLContext instance using protocol: {}", (Object)contextProtocol);
            SSLContext context = SSLContext.getInstance(contextProtocol);
            KeyManager[] keyMgrs = SslSupport.loadKeyManagers(options);
            TrustManager[] trustManagers = SslSupport.loadTrustManagers(options);
            context.init(keyMgrs, trustManagers, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            LOG.error("Failed to create SSLContext: {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static SSLEngine createClientJdkSslEngine(URI remote, SSLContext context, ProtonTestClientOptions options) throws Exception {
        SSLEngine engine = null;
        engine = remote == null ? context.createSSLEngine() : context.createSSLEngine(remote.getHost(), remote.getPort());
        engine.setEnabledProtocols(SslSupport.buildEnabledProtocols(engine, options));
        engine.setEnabledCipherSuites(SslSupport.buildEnabledCipherSuites(engine, options));
        engine.setUseClientMode(true);
        engine.setNeedClientAuth(options.isNeedClientAuth());
        if (options.isVerifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    public static SSLEngine createServerJdkSslEngine(URI remote, SSLContext context, ProtonTestServerOptions options) throws Exception {
        SSLEngine engine = null;
        engine = remote == null ? context.createSSLEngine() : context.createSSLEngine(remote.getHost(), remote.getPort());
        engine.setEnabledProtocols(SslSupport.buildEnabledProtocols(engine, options));
        engine.setEnabledCipherSuites(SslSupport.buildEnabledCipherSuites(engine, options));
        engine.setUseClientMode(false);
        engine.setNeedClientAuth(options.isNeedClientAuth());
        if (options.isVerifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    private static String[] buildEnabledProtocols(SSLEngine engine, ProtonTestClientOptions options) {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        if (options.getEnabledProtocols() != null) {
            List<String> configuredProtocols = Arrays.asList(options.getEnabledProtocols());
            LOG.trace("Configured protocols from transport options: {}", configuredProtocols);
            enabledProtocols.addAll(configuredProtocols);
        } else {
            List<String> engineProtocols = Arrays.asList(engine.getEnabledProtocols());
            LOG.trace("Default protocols from the SSLEngine: {}", engineProtocols);
            enabledProtocols.addAll(engineProtocols);
        }
        String[] disabledProtocols = options.getDisabledProtocols();
        if (disabledProtocols != null) {
            List<String> disabled = Arrays.asList(disabledProtocols);
            LOG.trace("Disabled protocols: {}", disabled);
            enabledProtocols.removeAll(disabled);
        }
        LOG.trace("Enabled protocols: {}", enabledProtocols);
        return enabledProtocols.toArray(new String[0]);
    }

    private static String[] buildEnabledProtocols(SSLEngine engine, ProtonTestServerOptions options) {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        if (options.getEnabledProtocols() != null) {
            List<String> configuredProtocols = Arrays.asList(options.getEnabledProtocols());
            LOG.trace("Configured protocols from transport options: {}", configuredProtocols);
            enabledProtocols.addAll(configuredProtocols);
        } else {
            List<String> engineProtocols = Arrays.asList(engine.getEnabledProtocols());
            LOG.trace("Default protocols from the SSLEngine: {}", engineProtocols);
            enabledProtocols.addAll(engineProtocols);
        }
        String[] disabledProtocols = options.getDisabledProtocols();
        if (disabledProtocols != null) {
            List<String> disabled = Arrays.asList(disabledProtocols);
            LOG.trace("Disabled protocols: {}", disabled);
            enabledProtocols.removeAll(disabled);
        }
        LOG.trace("Enabled protocols: {}", enabledProtocols);
        return enabledProtocols.toArray(new String[0]);
    }

    private static String[] buildEnabledCipherSuites(SSLEngine engine, ProtonTestServerOptions options) {
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        if (options.getEnabledCipherSuites() != null) {
            List<String> configuredCipherSuites = Arrays.asList(options.getEnabledCipherSuites());
            LOG.trace("Configured cipher suites from transport options: {}", configuredCipherSuites);
            enabledCipherSuites.addAll(configuredCipherSuites);
        } else {
            List<String> engineCipherSuites = Arrays.asList(engine.getEnabledCipherSuites());
            LOG.trace("Default cipher suites from the SSLEngine: {}", engineCipherSuites);
            enabledCipherSuites.addAll(engineCipherSuites);
        }
        String[] disabledCipherSuites = options.getDisabledCipherSuites();
        if (disabledCipherSuites != null) {
            List<String> disabled = Arrays.asList(disabledCipherSuites);
            LOG.trace("Disabled cipher suites: {}", disabled);
            enabledCipherSuites.removeAll(disabled);
        }
        LOG.trace("Enabled cipher suites: {}", enabledCipherSuites);
        return enabledCipherSuites.toArray(new String[0]);
    }

    private static String[] buildEnabledCipherSuites(SSLEngine engine, ProtonTestClientOptions options) {
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        if (options.getEnabledCipherSuites() != null) {
            List<String> configuredCipherSuites = Arrays.asList(options.getEnabledCipherSuites());
            LOG.trace("Configured cipher suites from transport options: {}", configuredCipherSuites);
            enabledCipherSuites.addAll(configuredCipherSuites);
        } else {
            List<String> engineCipherSuites = Arrays.asList(engine.getEnabledCipherSuites());
            LOG.trace("Default cipher suites from the SSLEngine: {}", engineCipherSuites);
            enabledCipherSuites.addAll(engineCipherSuites);
        }
        String[] disabledCipherSuites = options.getDisabledCipherSuites();
        if (disabledCipherSuites != null) {
            List<String> disabled = Arrays.asList(disabledCipherSuites);
            LOG.trace("Disabled cipher suites: {}", disabled);
            enabledCipherSuites.removeAll(disabled);
        }
        LOG.trace("Enabled cipher suites: {}", enabledCipherSuites);
        return enabledCipherSuites.toArray(new String[0]);
    }

    private static TrustManager[] loadTrustManagers(ProtonTestClientOptions options) throws Exception {
        TrustManagerFactory factory = SslSupport.loadTrustManagerFactory(options);
        if (factory != null) {
            return factory.getTrustManagers();
        }
        return null;
    }

    private static TrustManager[] loadTrustManagers(ProtonTestServerOptions options) throws Exception {
        TrustManagerFactory factory = SslSupport.loadTrustManagerFactory(options);
        if (factory != null) {
            return factory.getTrustManagers();
        }
        return null;
    }

    private static TrustManagerFactory loadTrustManagerFactory(ProtonTestClientOptions options) throws Exception {
        if (options.isTrustAll()) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        if (options.getTrustStoreLocation() == null) {
            return null;
        }
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getTrustStoreLocation();
        String storePassword = options.getTrustStorePassword();
        String storeType = options.getTrustStoreType();
        LOG.trace("Attempt to load TrustStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore trustStore = SslSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(trustStore);
        return fact;
    }

    private static TrustManagerFactory loadTrustManagerFactory(ProtonTestServerOptions options) throws Exception {
        if (options.isTrustAll()) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        if (options.getTrustStoreLocation() == null) {
            return null;
        }
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getTrustStoreLocation();
        String storePassword = options.getTrustStorePassword();
        String storeType = options.getTrustStoreType();
        LOG.trace("Attempt to load TrustStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore trustStore = SslSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(trustStore);
        return fact;
    }

    private static KeyManager[] loadKeyManagers(ProtonTestClientOptions options) throws Exception {
        if (options.getKeyStoreLocation() == null) {
            return null;
        }
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getKeyStoreLocation();
        String storePassword = options.getKeyStorePassword();
        String storeType = options.getKeyStoreType();
        String alias = options.getKeyAlias();
        LOG.trace("Attempt to load KeyStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore keyStore = SslSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(keyStore, storePassword != null ? storePassword.toCharArray() : null);
        if (alias == null) {
            return fact.getKeyManagers();
        }
        SslSupport.validateAlias(keyStore, alias);
        return SslSupport.wrapKeyManagers(alias, fact.getKeyManagers());
    }

    private static KeyManager[] loadKeyManagers(ProtonTestServerOptions options) throws Exception {
        if (options.getKeyStoreLocation() == null) {
            return null;
        }
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getKeyStoreLocation();
        String storePassword = options.getKeyStorePassword();
        String storeType = options.getKeyStoreType();
        String alias = options.getKeyAlias();
        LOG.trace("Attempt to load KeyStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore keyStore = SslSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(keyStore, storePassword != null ? storePassword.toCharArray() : null);
        if (alias == null) {
            return fact.getKeyManagers();
        }
        SslSupport.validateAlias(keyStore, alias);
        return SslSupport.wrapKeyManagers(alias, fact.getKeyManagers());
    }

    private static KeyManager[] wrapKeyManagers(String alias, KeyManager[] origKeyManagers) {
        KeyManager[] keyManagers = new KeyManager[origKeyManagers.length];
        for (int i = 0; i < origKeyManagers.length; ++i) {
            KeyManager km = origKeyManagers[i];
            if (km instanceof X509ExtendedKeyManager) {
                km = new X509AliasKeyManager(alias, (X509ExtendedKeyManager)km);
            }
            keyManagers[i] = km;
        }
        return keyManagers;
    }

    private static void validateAlias(KeyStore store, String alias) throws IllegalArgumentException, KeyStoreException {
        if (!store.containsAlias(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' doesn't exist in the key store");
        }
        if (!store.isKeyEntry(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' in the keystore doesn't represent a key entry");
        }
    }

    private static KeyStore loadStore(String storePath, String password, String storeType) throws Exception {
        KeyStore store = KeyStore.getInstance(storeType);
        try (FileInputStream in = new FileInputStream(new File(storePath));){
            store.load(in, password != null ? password.toCharArray() : null);
        }
        return store;
    }
}

