/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;

public class FrameEncoder {
    public static final byte AMQP_FRAME_TYPE = 0;
    public static final byte SASL_FRAME_TYPE = 1;
    private static final int AMQP_PERFORMATIVE_PAD = 512;
    private static final int FRAME_START_BYTE = 0;
    private static final int FRAME_DOFF_BYTE = 4;
    private static final int FRAME_DOFF_SIZE = 2;
    private static final int FRAME_TYPE_BYTE = 5;
    private static final int FRAME_CHANNEL_BYTE = 6;
    private static final int FRAME_HEADER_SIZE = 8;
    private static final byte[] FRAME_HEADER_RESERVED = new byte[8];
    private final AMQPTestDriver driver;
    private final Codec codec = Codec.Factory.create();

    public FrameEncoder(AMQPTestDriver driver) {
        this.driver = driver;
    }

    public ByteBuffer handleWrite(DescribedType performative, int channel, ByteBuffer payload, Runnable payloadToLarge) {
        return this.writeFrame(performative, payload, (byte)0, channel, this.driver.getOutboundMaxFrameSize(), payloadToLarge);
    }

    public ByteBuffer handleWrite(DescribedType performative, int channel) {
        return this.writeFrame(performative, null, (byte)1, 0, this.driver.getOutboundMaxFrameSize(), null);
    }

    private ByteBuffer writeFrame(DescribedType performative, ByteBuffer payload, byte frameType, int channel, int maxFrameSize, Runnable onPayloadTooLarge) {
        ByteBuffer byteBuffer;
        int outputBufferSize = 512 + (payload != null ? payload.remaining() : 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(outputBufferSize);
        try {
            int performativeSize = this.writePerformative(performative, payload, maxFrameSize, baos, onPayloadTooLarge);
            int capacity = maxFrameSize > 0 ? maxFrameSize - performativeSize : Integer.MAX_VALUE;
            int payloadSize = Math.min(payload == null ? 0 : payload.remaining(), capacity);
            if (payloadSize > 0) {
                byte[] payloadArray = new byte[payloadSize];
                payload.get(payloadArray);
                baos.write(payloadArray);
            }
            ByteBuffer output = ByteBuffer.wrap(baos.toByteArray());
            FrameEncoder.endFrame(output, frameType, channel);
            byteBuffer = output.asReadOnlyBuffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        baos.close();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePerformative(DescribedType performative, ByteBuffer payload, int maxFrameSize, ByteArrayOutputStream output, Runnable onPayloadTooLarge) {
        try {
            int performativeSize;
            output.write(FRAME_HEADER_RESERVED);
            long encodedSize = 0L;
            if (performative != null) {
                try {
                    this.codec.putDescribedType(performative);
                    encodedSize = this.codec.encode(output);
                }
                finally {
                    this.codec.clear();
                }
            }
            if ((long)(performativeSize = output.size() - 8) != encodedSize) {
                throw new IllegalStateException(String.format("Unable to encode performative %s of %d bytes into provided proton buffer, only wrote %d bytes", performative, performativeSize, encodedSize));
            }
            if (onPayloadTooLarge != null && maxFrameSize > 0 && payload != null && payload.remaining() + performativeSize > maxFrameSize) {
                onPayloadTooLarge.run();
                output.reset();
                performativeSize = this.writePerformative(performative, payload, maxFrameSize, output, null);
            }
            return performativeSize;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void endFrame(ByteBuffer output, byte frameType, int channel) {
        output.putInt(0, output.remaining());
        output.put(4, (byte)2);
        output.put(5, frameType);
        output.putShort(6, (short)channel);
    }
}

