/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Source;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Target;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.transactions.Coordinator;
import org.apache.qpid.protonj2.test.driver.codec.transport.Attach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Detach;
import org.apache.qpid.protonj2.test.driver.codec.transport.Flow;
import org.apache.qpid.protonj2.test.driver.codec.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;
import org.apache.qpid.protonj2.test.driver.codec.transport.SenderSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.transport.Transfer;

public abstract class LinkTracker {
    private final SessionTracker session;
    private Attach remoteAttach;
    private Detach remoteDetach;
    private Attach localAttach;
    private Detach localDetach;

    public LinkTracker(SessionTracker session) {
        this.session = session;
    }

    public SessionTracker getSession() {
        return this.session;
    }

    public String getName() {
        if (this.remoteAttach != null) {
            return this.remoteAttach.getName();
        }
        return this.localAttach.getName();
    }

    public Role getRole() {
        return this.isSender() ? Role.SENDER : Role.RECEIVER;
    }

    public SenderSettleMode getSenderSettleMode() {
        return this.localAttach.getSenderSettleMode() != null ? SenderSettleMode.valueOf(this.localAttach.getSenderSettleMode()) : SenderSettleMode.MIXED;
    }

    public ReceiverSettleMode getReceiverSettleMode() {
        return this.localAttach.getReceiverSettleMode() != null ? ReceiverSettleMode.valueOf(this.localAttach.getReceiverSettleMode()) : ReceiverSettleMode.FIRST;
    }

    public SenderSettleMode getRemoteSenderSettleMode() {
        return this.remoteAttach.getSenderSettleMode() != null ? SenderSettleMode.valueOf(this.remoteAttach.getSenderSettleMode()) : SenderSettleMode.MIXED;
    }

    public ReceiverSettleMode getRemoteReceiverSettleMode() {
        return this.remoteAttach.getReceiverSettleMode() != null ? ReceiverSettleMode.valueOf(this.remoteAttach.getReceiverSettleMode()) : ReceiverSettleMode.FIRST;
    }

    public UnsignedInteger getHandle() {
        return this.localAttach.getHandle();
    }

    public UnsignedInteger getRemoteHandle() {
        return this.remoteAttach.getHandle();
    }

    public Source getSource() {
        return this.localAttach.getSource();
    }

    public Target getTarget() {
        return this.localAttach.getTarget() instanceof Target ? (Target)this.localAttach.getTarget() : null;
    }

    public Coordinator getCoordinator() {
        return this.localAttach.getTarget() instanceof Coordinator ? (Coordinator)this.localAttach.getTarget() : null;
    }

    public Source getRemoteSource() {
        return this.remoteAttach.getSource();
    }

    public Target getRemoteTarget() {
        return this.remoteAttach.getTarget() instanceof Target ? (Target)this.remoteAttach.getTarget() : null;
    }

    public Coordinator getRemoteCoordinator() {
        return this.remoteAttach.getTarget() instanceof Coordinator ? (Coordinator)this.remoteAttach.getTarget() : null;
    }

    public boolean isRemotelyAttached() {
        return this.remoteAttach != null;
    }

    public boolean isRemotelyDetached() {
        return this.remoteDetach != null;
    }

    public boolean isLocallyAttached() {
        return this.localAttach != null;
    }

    public boolean isLocallyDetached() {
        return this.localDetach != null;
    }

    public LinkTracker handleLocalAttach(Attach localAttach) {
        this.localAttach = localAttach;
        return this;
    }

    public LinkTracker handleLocalDetach(Detach localDetach) {
        this.localDetach = localDetach;
        return this;
    }

    public void handlerRemoteAttach(Attach remoteAttach) {
        this.remoteAttach = remoteAttach;
    }

    public LinkTracker handleRemoteDetach(Detach remoteDetach) {
        this.remoteDetach = remoteDetach;
        return this;
    }

    protected abstract void handleTransfer(Transfer var1, ByteBuffer var2);

    protected abstract void handleFlow(Flow var1);

    public abstract boolean isSender();

    public abstract boolean isReceiver();
}

