/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;

public class ProtonTestConnector
extends ProtonTestPeer
implements Consumer<ByteBuffer> {
    private final AMQPTestDriver driver = new AMQPTestDriver(this.getPeerName(), frame -> this.processDriverOutput((ByteBuffer)frame), null);
    private final Consumer<ByteBuffer> inputConsumer;

    public ProtonTestConnector(Consumer<ByteBuffer> frameSink) {
        this.inputConsumer = frameSink;
    }

    @Override
    public String getPeerName() {
        return "InVMConnector";
    }

    @Override
    public void accept(ByteBuffer frame) {
        if (this.closed.get()) {
            throw new UncheckedIOException("Closed driver is not accepting any new input", new IOException());
        }
        this.driver.accept(frame);
    }

    @Override
    public AMQPTestDriver getDriver() {
        return this.driver;
    }

    @Override
    protected void processCloseConnectionRequest() {
    }

    @Override
    protected void processPeerShutdownRequest() {
    }

    @Override
    protected void processDriverOutput(ByteBuffer frame) {
        this.inputConsumer.accept(frame);
    }

    @Override
    protected void processConnectionEstablished() {
        this.driver.handleConnectedEstablished();
    }

    @Override
    protected void processConnectionDropped() {
        this.driver.handleConnectedDropped();
    }
}

