/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class ProtonTestServerOptions
implements Cloneable {
    private static final int SERVER_CHOOSES_PORT = 0;
    public static final int DEFAULT_SEND_BUFFER_SIZE = 65536;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 65536;
    public static final int DEFAULT_TRAFFIC_CLASS = 0;
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final int DEFAULT_SO_LINGER = Integer.MIN_VALUE;
    public static final int DEFAULT_SO_TIMEOUT = -1;
    public static final int DEFAULT_SERVER_PORT = 0;
    public static final boolean DEFAULT_TRACE_BYTES = false;
    public static final String DEFAULT_STORE_TYPE = "jks";
    public static final String DEFAULT_CONTEXT_PROTOCOL = "TLS";
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final boolean DEFAULT_VERIFY_HOST = true;
    public static final List<String> DEFAULT_DISABLED_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("SSLv2Hello", "SSLv3"));
    public static final int DEFAULT_LOCAL_PORT = 0;
    public static final boolean DEFAULT_USE_WEBSOCKETS = false;
    public static final boolean DEFAULT_FRAGMENT_WEBSOCKET_WRITES = false;
    public static final boolean DEFAULT_WEBSOCKET_COMPRESSION = false;
    public static final boolean DEFAULT_SECURE_SERVER = false;
    public static final boolean DEFAULT_NEEDS_CLIENT_AUTH = false;
    private static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JAVAX_NET_SSL_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String JAVAX_NET_SSL_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private int sendBufferSize = 65536;
    private int receiveBufferSize = 65536;
    private int trafficClass = 0;
    private int soTimeout = -1;
    private int soLinger = Integer.MIN_VALUE;
    private boolean tcpKeepAlive = false;
    private boolean tcpNoDelay = true;
    private int serverPort = 0;
    private String localAddress;
    private int localPort = 0;
    private boolean traceBytes = false;
    private boolean useWebSockets = false;
    private boolean webSocketCompression = false;
    private boolean fragmentWebSocketWrites = false;
    private boolean secure = false;
    private boolean needClientAuth = false;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String keyStoreType;
    private String trustStoreType;
    private String[] enabledCipherSuites;
    private String[] disabledCipherSuites;
    private String[] enabledProtocols;
    private String[] disabledProtocols = DEFAULT_DISABLED_PROTOCOLS.toArray(new String[0]);
    private String contextProtocol = "TLS";
    private boolean trustAll = false;
    private boolean verifyHost = true;
    private String keyAlias;
    private SSLContext sslContextOverride;
    private final Map<String, String> httpHeaders = new HashMap<String, String>();

    public ProtonTestServerOptions() {
        this.setKeyStoreLocation(System.getProperty(JAVAX_NET_SSL_KEY_STORE));
        this.setKeyStoreType(System.getProperty(JAVAX_NET_SSL_KEY_STORE_TYPE, DEFAULT_STORE_TYPE));
        this.setKeyStorePassword(System.getProperty(JAVAX_NET_SSL_KEY_STORE_PASSWORD));
        this.setTrustStoreLocation(System.getProperty(JAVAX_NET_SSL_TRUST_STORE));
        this.setTrustStoreType(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_TYPE, DEFAULT_STORE_TYPE));
        this.setTrustStorePassword(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD));
    }

    public ProtonTestServerOptions clone() {
        return this.copyOptions(new ProtonTestServerOptions());
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public ProtonTestServerOptions setSendBufferSize(int sendBufferSize) {
        if (sendBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public ProtonTestServerOptions setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public ProtonTestServerOptions setTrafficClass(int trafficClass) {
        if (trafficClass < 0 || trafficClass > 255) {
            throw new IllegalArgumentException("Traffic class must be in the range [0..255]");
        }
        this.trafficClass = trafficClass;
        return this;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public ProtonTestServerOptions setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public ProtonTestServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public ProtonTestServerOptions setSoLinger(int soLinger) {
        this.soLinger = soLinger;
        return this;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public ProtonTestServerOptions setTcpKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
        return this;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ProtonTestServerOptions setServerPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public ProtonTestServerOptions setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public ProtonTestServerOptions setLocalPort(int localPort) {
        this.localPort = localPort;
        return this;
    }

    public boolean isTraceBytes() {
        return this.traceBytes;
    }

    public ProtonTestServerOptions setTraceBytes(boolean traceBytes) {
        this.traceBytes = traceBytes;
        return this;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public ProtonTestServerOptions setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public ProtonTestServerOptions setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public ProtonTestServerOptions setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public ProtonTestServerOptions setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public ProtonTestServerOptions setStoreType(String storeType) {
        this.setKeyStoreType(storeType);
        this.setTrustStoreType(storeType);
        return this;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public ProtonTestServerOptions setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public ProtonTestServerOptions setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public ProtonTestServerOptions setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
        return this;
    }

    public String[] getDisabledCipherSuites() {
        return this.disabledCipherSuites;
    }

    public ProtonTestServerOptions setDisabledCipherSuites(String[] disabledCipherSuites) {
        this.disabledCipherSuites = disabledCipherSuites;
        return this;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public ProtonTestServerOptions setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public String[] getDisabledProtocols() {
        return this.disabledProtocols;
    }

    public ProtonTestServerOptions setDisabledProtocols(String[] disabledProtocols) {
        this.disabledProtocols = disabledProtocols;
        return this;
    }

    public String getContextProtocol() {
        return this.contextProtocol;
    }

    public ProtonTestServerOptions setContextProtocol(String contextProtocol) {
        this.contextProtocol = contextProtocol;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public ProtonTestServerOptions setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public ProtonTestServerOptions setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public ProtonTestServerOptions setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public SSLContext getSslContextOverride() {
        return this.sslContextOverride;
    }

    public ProtonTestServerOptions setSslContextOverride(SSLContext sslContextOverride) {
        this.sslContextOverride = sslContextOverride;
        return this;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public ProtonTestServerOptions setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public ProtonTestServerOptions setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public boolean isUseWebSockets() {
        return this.useWebSockets;
    }

    public ProtonTestServerOptions setUseWebSockets(boolean useWebSockets) {
        this.useWebSockets = useWebSockets;
        return this;
    }

    public boolean isFragmentWrites() {
        return this.fragmentWebSocketWrites;
    }

    public ProtonTestServerOptions setFragmentWrites(boolean fragmentWrites) {
        this.fragmentWebSocketWrites = fragmentWrites;
        return this;
    }

    public boolean isWebSocketCompression() {
        return this.webSocketCompression;
    }

    public ProtonTestServerOptions setWebSocketCompression(boolean enabled) {
        this.webSocketCompression = enabled;
        return this;
    }

    protected ProtonTestServerOptions copyOptions(ProtonTestServerOptions copy) {
        copy.setReceiveBufferSize(this.getReceiveBufferSize());
        copy.setSendBufferSize(this.getSendBufferSize());
        copy.setSoLinger(this.getSoLinger());
        copy.setSoTimeout(this.getSoTimeout());
        copy.setTcpKeepAlive(this.isTcpKeepAlive());
        copy.setTcpNoDelay(this.isTcpNoDelay());
        copy.setTrafficClass(this.getTrafficClass());
        copy.setServerPort(this.getServerPort());
        copy.setTraceBytes(this.isTraceBytes());
        copy.setKeyStoreLocation(this.getKeyStoreLocation());
        copy.setKeyStorePassword(this.getKeyStorePassword());
        copy.setTrustStoreLocation(this.getTrustStoreLocation());
        copy.setTrustStorePassword(this.getTrustStorePassword());
        copy.setKeyStoreType(this.getKeyStoreType());
        copy.setTrustStoreType(this.getTrustStoreType());
        copy.setEnabledCipherSuites(this.getEnabledCipherSuites());
        copy.setDisabledCipherSuites(this.getDisabledCipherSuites());
        copy.setEnabledProtocols(this.getEnabledProtocols());
        copy.setDisabledProtocols(this.getDisabledProtocols());
        copy.setTrustAll(this.isTrustAll());
        copy.setVerifyHost(this.isVerifyHost());
        copy.setKeyAlias(this.getKeyAlias());
        copy.setContextProtocol(this.getContextProtocol());
        copy.setSslContextOverride(this.getSslContextOverride());
        copy.setLocalAddress(this.getLocalAddress());
        copy.setLocalPort(this.getLocalPort());
        copy.setSecure(this.isSecure());
        copy.setNeedClientAuth(this.isNeedClientAuth());
        copy.setUseWebSockets(this.isUseWebSockets());
        copy.setFragmentWrites(this.isFragmentWrites());
        copy.setWebSocketCompression(this.isWebSocketCompression());
        return copy;
    }
}

