/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.DeferrableScriptedAction;
import org.apache.qpid.protonj2.test.driver.codec.transport.AMQPHeader;

public class AMQPHeaderInjectAction
implements DeferrableScriptedAction {
    private final AMQPTestDriver driver;
    private final AMQPHeader header;
    private boolean deferred = false;

    public AMQPHeaderInjectAction(AMQPTestDriver driver, AMQPHeader header) {
        this.header = header;
        this.driver = driver;
    }

    @Override
    public AMQPHeaderInjectAction perform(AMQPTestDriver driver) {
        if (this.deferred) {
            driver.deferHeader(this.header);
        } else {
            driver.sendHeader(this.header);
        }
        return this;
    }

    @Override
    public AMQPHeaderInjectAction now() {
        this.perform(this.driver);
        return this;
    }

    @Override
    public AMQPHeaderInjectAction later(int delay) {
        this.driver.afterDelay(delay, this);
        return this;
    }

    @Override
    public AMQPHeaderInjectAction queue() {
        this.driver.addScriptedElement(this);
        return this;
    }

    @Override
    public AMQPHeaderInjectAction deferred() {
        this.deferred = true;
        return this;
    }

    @Override
    public boolean isDeffered() {
        return this.deferred;
    }
}

