/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.DeferrableScriptedAction;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;

public abstract class AbstractSaslPerformativeInjectAction<P extends DescribedType>
implements DeferrableScriptedAction {
    public static final int CHANNEL_UNSET = -1;
    private final AMQPTestDriver driver;
    private boolean deferred = false;
    private int channel = -1;

    public AbstractSaslPerformativeInjectAction(AMQPTestDriver driver) {
        this.driver = driver;
    }

    @Override
    public AbstractSaslPerformativeInjectAction<P> now() {
        this.perform(this.driver);
        return this;
    }

    @Override
    public AbstractSaslPerformativeInjectAction<P> later(int delay) {
        this.driver.afterDelay(delay, this);
        return this;
    }

    @Override
    public AbstractSaslPerformativeInjectAction<P> queue() {
        this.driver.addScriptedElement(this);
        return this;
    }

    @Override
    public AbstractSaslPerformativeInjectAction<P> deferred() {
        this.deferred = true;
        return this;
    }

    @Override
    public boolean isDeffered() {
        return this.deferred;
    }

    @Override
    public AbstractSaslPerformativeInjectAction<P> perform(AMQPTestDriver driver) {
        if (this.deferred) {
            driver.deferSaslFrame(this.onChannel(), (DescribedType)this.getPerformative());
        } else {
            driver.sendSaslFrame(this.onChannel(), (DescribedType)this.getPerformative());
        }
        return this;
    }

    public int onChannel() {
        return this.channel;
    }

    public AbstractSaslPerformativeInjectAction<?> onChannel(int channel) {
        this.channel = channel;
        return this;
    }

    public abstract P getPerformative();
}

