/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.util.Map;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.AbstractPerformativeInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Detach;
import org.apache.qpid.protonj2.test.driver.codec.transport.ErrorCondition;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;

public class DetachInjectAction
extends AbstractPerformativeInjectAction<Detach> {
    private final Detach detach = new Detach();

    public DetachInjectAction(AMQPTestDriver driver) {
        super(driver);
    }

    @Override
    public Detach getPerformative() {
        return this.detach;
    }

    public DetachInjectAction withHandle(int handle) {
        this.detach.setHandle(UnsignedInteger.valueOf(handle));
        return this;
    }

    public DetachInjectAction withHandle(long handle) {
        this.detach.setHandle(UnsignedInteger.valueOf(handle));
        return this;
    }

    public DetachInjectAction withHandle(UnsignedInteger handle) {
        this.detach.setHandle(handle);
        return this;
    }

    public DetachInjectAction withClosed(boolean closed) {
        this.detach.setClosed(closed);
        return this;
    }

    public DetachInjectAction withClosed(Boolean closed) {
        this.detach.setClosed(closed);
        return this;
    }

    public DetachInjectAction withErrorCondition(ErrorCondition error) {
        this.detach.setError(error);
        return this;
    }

    public DetachInjectAction withErrorCondition(String condition, String description) {
        this.detach.setError(new ErrorCondition(Symbol.valueOf(condition), description));
        return this;
    }

    public DetachInjectAction withErrorCondition(Symbol condition, String description) {
        this.detach.setError(new ErrorCondition(condition, description));
        return this;
    }

    public DetachInjectAction withErrorCondition(String condition, String description, Map<String, Object> info) {
        this.detach.setError(new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info)));
        return this;
    }

    public DetachInjectAction withErrorCondition(Symbol condition, String description, Map<Symbol, Object> info) {
        this.detach.setError(new ErrorCondition(condition, description, info));
        return this;
    }

    @Override
    protected void beforeActionPerformed(AMQPTestDriver driver) {
        if (this.onChannel() == -1) {
            if (driver.sessions().getLastLocallyOpenedSession() == null) {
                throw new AssertionError((Object)"Scripted Action cannot run without a configured channel: No locally opened session exists to auto select a channel.");
            }
            this.onChannel(driver.sessions().getLastLocallyOpenedSession().getLocalChannel().intValue());
        }
        UnsignedShort localChannel = UnsignedShort.valueOf(this.onChannel());
        SessionTracker session = driver.sessions().getSessionFromLocalChannel(localChannel);
        if (session != null) {
            if (this.detach.getHandle() == null) {
                this.detach.setHandle(session.getLastOpenedLink().getHandle());
            }
            session.handleLocalDetach(this.detach);
        }
    }
}

