/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ScriptedAction;

public class ExecuteUserCodeAction
implements ScriptedAction {
    private final AMQPTestDriver driver;
    private final Runnable action;
    private int delay = -1;

    public ExecuteUserCodeAction(AMQPTestDriver driver, Runnable action) {
        Objects.requireNonNull(driver, "Test Driver to use cannot be null");
        Objects.requireNonNull(action, "Action to run cannot be null");
        this.driver = driver;
        this.action = action;
    }

    public int afterDelay() {
        return this.delay;
    }

    public ExecuteUserCodeAction afterDelay(int delay) {
        this.delay = delay;
        return this;
    }

    @Override
    public ExecuteUserCodeAction now() {
        ForkJoinPool.commonPool().execute(this.action);
        return this;
    }

    @Override
    public ExecuteUserCodeAction later(int delay) {
        this.driver.afterDelay(delay, this);
        return this;
    }

    @Override
    public ExecuteUserCodeAction queue() {
        this.driver.addScriptedElement(this);
        return this;
    }

    @Override
    public ExecuteUserCodeAction perform(AMQPTestDriver driver) {
        if (this.afterDelay() > 0) {
            driver.afterDelay(this.afterDelay(), new ScriptedAction(){

                @Override
                public ScriptedAction queue() {
                    return this;
                }

                @Override
                public ScriptedAction perform(AMQPTestDriver driver) {
                    this.now();
                    return this;
                }

                @Override
                public ScriptedAction now() {
                    return this;
                }

                @Override
                public ScriptedAction later(int waitTime) {
                    return this;
                }
            });
        } else {
            this.now();
        }
        return this;
    }
}

