/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.AbstractPerformativeInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.transport.Flow;

public class FlowInjectAction
extends AbstractPerformativeInjectAction<Flow> {
    private final Flow flow = new Flow();
    private boolean explicitlyNullHandle;

    public FlowInjectAction(AMQPTestDriver driver) {
        super(driver);
    }

    @Override
    public Flow getPerformative() {
        return this.flow;
    }

    public FlowInjectAction withNextIncomingId(long nextIncomingId) {
        this.flow.setNextIncomingId(UnsignedInteger.valueOf(nextIncomingId));
        return this;
    }

    public FlowInjectAction withNextIncomingId(UnsignedInteger nextIncomingId) {
        this.flow.setNextIncomingId(nextIncomingId);
        return this;
    }

    public FlowInjectAction withIncomingWindow(long incomingWindow) {
        this.flow.setIncomingWindow(UnsignedInteger.valueOf(incomingWindow));
        return this;
    }

    public FlowInjectAction withIncomingWindow(UnsignedInteger incomingWindow) {
        this.flow.setIncomingWindow(incomingWindow);
        return this;
    }

    public FlowInjectAction withNextOutgoingId(long nextOutgoingId) {
        this.flow.setNextOutgoingId(UnsignedInteger.valueOf(nextOutgoingId));
        return this;
    }

    public FlowInjectAction withNextOutgoingId(UnsignedInteger nextOutgoingId) {
        this.flow.setNextOutgoingId(nextOutgoingId);
        return this;
    }

    public FlowInjectAction withOutgoingWindow(long outgoingWindow) {
        this.flow.setOutgoingWindow(UnsignedInteger.valueOf(outgoingWindow));
        return this;
    }

    public FlowInjectAction withOutgoingWindow(UnsignedInteger outgoingWindow) {
        this.flow.setOutgoingWindow(outgoingWindow);
        return this;
    }

    public FlowInjectAction withHandle(long handle) {
        this.flow.setHandle(UnsignedInteger.valueOf(handle));
        return this;
    }

    public FlowInjectAction withHandle(UnsignedInteger handle) {
        this.explicitlyNullHandle = handle == null;
        this.flow.setHandle(handle);
        return this;
    }

    public FlowInjectAction withNullHandle() {
        this.explicitlyNullHandle = true;
        this.flow.setHandle(null);
        return this;
    }

    public FlowInjectAction withDeliveryCount(long deliveryCount) {
        this.flow.setDeliveryCount(UnsignedInteger.valueOf(deliveryCount));
        return this;
    }

    public FlowInjectAction withDeliveryCount(UnsignedInteger deliveryCount) {
        this.flow.setDeliveryCount(deliveryCount);
        return this;
    }

    public FlowInjectAction withLinkCredit(long linkCredit) {
        this.flow.setLinkCredit(UnsignedInteger.valueOf(linkCredit));
        return this;
    }

    public FlowInjectAction withLinkCredit(UnsignedInteger linkCredit) {
        this.flow.setLinkCredit(linkCredit);
        return this;
    }

    public FlowInjectAction withAvailable(long available) {
        this.flow.setAvailable(UnsignedInteger.valueOf(available));
        return this;
    }

    public FlowInjectAction withAvailable(UnsignedInteger available) {
        this.flow.setAvailable(available);
        return this;
    }

    public FlowInjectAction withDrain(boolean drain) {
        this.flow.setDrain(drain);
        return this;
    }

    public FlowInjectAction withEcho(boolean echo) {
        this.flow.setEcho(echo);
        return this;
    }

    public FlowInjectAction withProperties(Map<Symbol, Object> properties) {
        this.flow.setProperties(properties);
        return this;
    }

    public FlowInjectAction withProperty(Symbol key, Object value) {
        if (this.flow.getProperties() == null) {
            this.flow.setProperties(new LinkedHashMap<Symbol, Object>());
        }
        this.flow.getProperties().put(key, value);
        return this;
    }

    public FlowInjectAction withProperty(String key, Object value) {
        return this.withProperty(Symbol.valueOf(key), value);
    }

    @Override
    protected void beforeActionPerformed(AMQPTestDriver driver) {
        SessionTracker session = driver.sessions().getLastLocallyOpenedSession();
        LinkTracker link = session.getLastOpenedLink();
        if (this.onChannel() == -1) {
            this.onChannel(session.getLocalChannel().intValue());
        }
        if (this.flow.getHandle() == null && !this.explicitlyNullHandle && link != null) {
            this.flow.setHandle(link.getHandle());
        }
        if (this.flow.getIncomingWindow() == null) {
            this.flow.setIncomingWindow(session.getLocalBegin().getIncomingWindow());
        }
        if (this.flow.getNextIncomingId() == null) {
            this.flow.setNextIncomingId(session.getNextIncomingId());
        }
        if (this.flow.getNextOutgoingId() == null) {
            this.flow.setNextOutgoingId(session.getLocalBegin().getNextOutgoingId());
        }
        if (this.flow.getOutgoingWindow() == null) {
            this.flow.setOutgoingWindow(session.getLocalBegin().getOutgoingWindow());
        }
    }
}

