/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.Element;

abstract class AbstractElement<T>
implements Element<T> {
    private Element<?> parent;
    private Element<?> next;
    private Element<?> prev;

    AbstractElement(Element<?> parent, Element<?> prev) {
        this.parent = parent;
        this.prev = prev;
    }

    protected boolean isElementOfArray() {
        return this.parent instanceof ArrayElement && (!((ArrayElement)this.parent()).isDescribed() || this != this.parent.child());
    }

    @Override
    public Element<?> next() {
        return this.next;
    }

    @Override
    public Element<?> prev() {
        return this.prev;
    }

    @Override
    public Element<?> parent() {
        return this.parent;
    }

    @Override
    public void setNext(Element<?> elt) {
        this.next = elt;
    }

    @Override
    public void setPrev(Element<?> elt) {
        this.prev = elt;
    }

    @Override
    public void setParent(Element<?> elt) {
        this.parent = elt;
    }

    @Override
    public Element<?> replaceWith(Element<?> elt) {
        if (this.parent != null) {
            elt = this.parent.checkChild(elt);
        }
        elt.setPrev(this.prev);
        elt.setNext(this.next);
        elt.setParent(this.parent);
        if (this.prev != null) {
            this.prev.setNext(elt);
        }
        if (this.next != null) {
            this.next.setPrev(elt);
        }
        if (this.parent != null && this.parent.child() == this) {
            this.parent.setChild(elt);
        }
        return elt;
    }

    public String toString() {
        return String.format("%s[%h]{parent=%h, prev=%h, next=%h}", this.getClass().getSimpleName(), System.identityHashCode(this), System.identityHashCode(this.parent), System.identityHashCode(this.prev), System.identityHashCode(this.next));
    }

    abstract String startSymbol();

    abstract String stopSymbol();

    @Override
    public void render(StringBuilder sb) {
        if (this.canEnter()) {
            sb.append(this.startSymbol());
            boolean first = true;
            for (Element<?> el = this.child(); el != null; el = el.next()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                el.render(sb);
            }
            sb.append(this.stopSymbol());
        } else {
            sb.append((Object)this.getDataType()).append(" ").append(this.getValue());
        }
    }
}

