/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal128;

class Decimal128Element
extends AtomicElement<Decimal128> {
    private final Decimal128 value;

    Decimal128Element(Element<?> parent, Element<?> prev, Decimal128 d) {
        super(parent, prev);
        this.value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 16 : 17;
    }

    @Override
    public Decimal128 getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.DECIMAL128;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            if (size == 17) {
                output.writeByte(-108);
            }
            output.writeLong(this.value.getMostSignificantBits());
            output.writeLong(this.value.getLeastSignificantBits());
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

