/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal32;

class Decimal32Element
extends AtomicElement<Decimal32> {
    private final Decimal32 value;

    Decimal32Element(Element<?> parent, Element<?> prev, Decimal32 d) {
        super(parent, prev);
        this.value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 4 : 5;
    }

    @Override
    public Decimal32 getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.DECIMAL32;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            if (size == 5) {
                output.writeByte(116);
            }
            output.writeInt(this.value.getBits());
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

