/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class FloatElement
extends AtomicElement<Float> {
    private final float value;

    FloatElement(Element<?> parent, Element<?> prev, float f) {
        super(parent, prev);
        this.value = f;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 4 : 5;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.FLOAT;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        try {
            if (size == 5) {
                output.writeByte(114);
            }
            output.writeFloat(this.value);
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

