/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.protonj2.test.driver.codec.AbstractElement;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class ListElement
extends AbstractElement<List<Object>> {
    private Element<?> first;

    ListElement(Element<?> parent, Element<?> prev) {
        super(parent, prev);
    }

    public int count() {
        int count = 0;
        for (Element<?> elt = this.first; elt != null; elt = elt.next()) {
            ++count;
        }
        return count;
    }

    @Override
    public int size() {
        int count = 0;
        int size = 0;
        for (Element<?> elt = this.first; elt != null; elt = elt.next()) {
            ++count;
            size += elt.size();
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.TINY) {
                if (count != 0) {
                    parent.setConstructorType(ArrayElement.ConstructorType.SMALL);
                    size += 2;
                }
            } else if (parent.constructorType() == ArrayElement.SMALL) {
                if (count > 255 || size > 254) {
                    parent.setConstructorType(ArrayElement.ConstructorType.LARGE);
                    size += 8;
                } else {
                    size += 2;
                }
            } else {
                size += 8;
            }
        } else {
            size = count == 0 ? 1 : (count <= 255 && size <= 254 ? (size += 3) : (size += 9));
        }
        return size;
    }

    @Override
    public List<Object> getValue() {
        ArrayList list = new ArrayList();
        for (Element<?> elt = this.first; elt != null; elt = elt.next()) {
            list.add(elt.getValue());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.LIST;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            Element<?> elt;
            int encodedSize = this.size();
            int count = 0;
            int size = 0;
            for (elt = this.first; elt != null; elt = elt.next()) {
                ++count;
                size += elt.size();
            }
            if (this.isElementOfArray()) {
                switch (((ArrayElement)this.parent()).constructorType()) {
                    case TINY: {
                        break;
                    }
                    case SMALL: {
                        output.writeByte((byte)(size + 1));
                        output.writeByte((byte)count);
                        break;
                    }
                    case LARGE: {
                        output.writeInt(size + 4);
                        output.writeInt(count);
                    }
                }
            } else if (count == 0) {
                output.writeByte(69);
            } else if (size <= 254 && count <= 255) {
                output.writeByte(-64);
                output.writeByte((byte)(size + 1));
                output.writeByte((byte)count);
            } else {
                output.writeByte(-48);
                output.writeInt(size + 4);
                output.writeInt(count);
            }
            for (elt = this.first; elt != null; elt = elt.next()) {
                elt.encode(output);
            }
            return encodedSize;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    @Override
    public Element<?> child() {
        return this.first;
    }

    @Override
    public void setChild(Element<?> elt) {
        this.first = elt;
    }

    @Override
    public Element<?> checkChild(Element<?> element) {
        return element;
    }

    @Override
    public Element<?> addChild(Element<?> element) {
        this.first = element;
        return element;
    }

    @Override
    String startSymbol() {
        return "[";
    }

    @Override
    String stopSymbol() {
        return "]";
    }
}

