/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class LongElement
extends AtomicElement<Long> {
    private final long value;

    LongElement(Element<?> parent, Element<?> prev, long l) {
        super(parent, prev);
        this.value = l;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (-128L <= this.value && this.value <= 127L) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
            }
            return 8;
        }
        return -128L <= this.value && this.value <= 127L ? 2 : 9;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.LONG;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            int size = this.size();
            switch (size) {
                case 2: {
                    output.writeByte(85);
                }
                case 1: {
                    output.writeByte((byte)this.value);
                    break;
                }
                case 9: {
                    output.writeByte(-127);
                }
                case 8: {
                    output.writeLong(this.value);
                }
            }
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

