/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;

class SymbolElement
extends AtomicElement<Symbol> {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private final Symbol value;

    SymbolElement(Element<?> parent, Element<?> prev, Symbol s) {
        super(parent, prev);
        this.value = s;
    }

    @Override
    public int size() {
        int length = this.value.getLength();
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (length > 255) {
                    parent.setConstructorType(ArrayElement.LARGE);
                    return 4 + length;
                }
                return 1 + length;
            }
            return 4 + length;
        }
        if (length > 255) {
            return 5 + length;
        }
        return 2 + length;
    }

    @Override
    public Symbol getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.SYMBOL;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            int size = this.size();
            if (this.isElementOfArray()) {
                ArrayElement parent = (ArrayElement)this.parent();
                if (parent.constructorType() == ArrayElement.SMALL) {
                    output.writeByte((byte)this.value.getLength());
                } else {
                    output.writeInt(this.value.getLength());
                }
            } else if (this.value.getLength() <= 255) {
                output.writeByte(-93);
                output.writeByte((byte)this.value.getLength());
            } else {
                output.writeByte(-77);
                output.writeByte((byte)this.value.getLength());
            }
            output.write(this.value.toString().getBytes(ASCII));
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

